/*!
 * Copyright (c) 2017 Apple Inc. All rights reserved.
 * 
 * # LivePhotosKit JS License
 * 
 * **IMPORTANT:** This Apple LivePhotosKit software is supplied to you by Apple
 * Inc. ("Apple") in consideration of your agreement to the following terms, and
 * your use, reproduction, installation, of this Apple software constitutes
 * acceptance of these terms. If you do not agree with these terms, please do not
 * use, reproduce or install this Apple software.
 * 
 * **To the extent that this software may be used to reproduce, modify, publish or
 * distribute materials, it is licensed to you only for reproduction, modification,
 * publication and distribution of non-copyrighted materials, materials in which
 * you own the copyright, or materials you are authorized or legally permitted to
 * reproduce, modify, publish or distribute. If you are uncertain about your right
 * to copy any material, you should contact your legal advisor.**
 * 
 * In consideration of your agreement to abide by the following terms, conditioned
 * upon your compliance with them and subject to these terms, Apple grants you a
 * limited, non-exclusive, non-transferable license, under Apple's copyrights in
 * the LivePhotosKit software, including but not limited to, the LivePhotosKit
 * documentation (collectively the "LivePhotosKit Software") to install and
 * internally use, within your company or organization, a reasonable number of
 * copies of the LivePhotosKit Software on computers owned or controlled by you,
 * for the purpose of embedding LivePhotos on your website. The LivePhotosKit
 * Software may not be redistributed outside of your company or organization.
 * 
 * The LivePhotosKit Software is only licensed and intended for the purposes set
 * forth above and may not be used for other purposes or in other contexts without
 * Apple's prior written permission.
 * 
 * Neither the name, trademarks, service marks or logos of Apple Inc. may be used
 * to endorse or promote products, services or other materials derived from the
 * LivePhotosKit Software without specific prior written permission from Apple.
 * Except as expressly stated in this notice, no other rights or licenses, express
 * or implied, are granted by Apple herein.
 * 
 * The LivePhotosKit Software is provided by Apple on an "AS IS" basis. APPLE MAKES
 * NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLED
 * WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, REGARDING THE LIVEPHOTOSKIT SOFTWARE OR ITS USE AND OPERATION ALONE OR
 * IN COMBINATION WITH YOUR PRODUCTS, SYSTEMS, OR SERVICES. APPLE DOES NOT WARRANT
 * THAT THE LIVEPHOTOSKIT SOFTWARE WILL MEET YOUR REQUIREMENTS, THAT THE OPERATION
 * OF THE LIVEPHOTOSKIT SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE, THAT DEFECTS
 * IN THE LIVEPHOTOSKIT MATERIALS WILL BE CORRECTED, OR THAT THE LIVEPHOTOSKIT
 * SOFTWARE WILL BE COMPATIBLE WITH FUTURE APPLE PRODUCTS, SOFTWARE OR SERVICES. NO
 * ORAL OR WRITTEN INFORMATION OR ADVICE GIVEN BY APPLE OR AN APPLE AUTHORIZED
 * REPRESENTATIVE WILL CREATE A WARRANTY.
 * 
 * IN NO EVENT SHALL APPLE BE LIABLE FOR ANY DIRECT, SPECIAL, INDIRECT, INCIDENTAL
 * OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) RELATING TO OR ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION,
 * INSTALLATION, OF THE LIVEPHOTOSKIT SOFTWARE BY YOU OR OTHERS, HOWEVER CAUSED AND
 * WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY
 * OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * 
 * **ACKNOWLEDGEMENTS:**
 * https://cdn.apple-livephotoskit.com/lpk/1/acknowledgements.txt
 * 
 * v1.4.9
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.LivePhotosKit=t():e.LivePhotosKit=t()}(this,function(){return function(e){function t(i){if(r[i])return r[i].exports;var n=r[i]={i:i,l:!1,exports:{}};return e[i].call(n.exports,n,n.exports,t),n.l=!0,n.exports}var r={};return t.m=e,t.c=r,t.i=function(e){return e},t.d=function(e,r,i){t.o(e,r)||Object.defineProperty(e,r,{configurable:!1,enumerable:!0,get:i})},t.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(r,"a",r),r},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=21)}([function(e,t,r){"use strict";function i(e){if(e){var t=e.staticMembers;t&&n.call(this,t),n.call(this.prototype,e)}}function n(e){for(var t in e)if(e.hasOwnProperty(t)&&"staticMembers"!==t){var r=Object.getOwnPropertyDescriptor(e,t);r.get||r.set?Object.defineProperty(this,t,r):a.call(this,t,e[t])}}function a(e,t){var r=this[e];return r instanceof Function&&t instanceof Function?o.call(this,e,t,r):F.instanceOrKindOf(t,F.Metadata)?s.call(this,e,t):void(this[e]=t)}function o(e,t,r){this[e]=function(){var e=this._super;this._super=r;var i=t.apply(this,arguments);return this._super=e,i}}function s(e,t){this.hasOwnProperty("_metadatas")||(this._metadatas=Object.create(this._metadatas)),(t.isLPKClass?t.sharedInstance:t).registerOnDefinition(this,e)}function u(e){var t=this["_callbacksFor_"+e];if(t){var r=void 0;if(arguments.length>1){r=F.arrayPool.get();for(var i=1,n=arguments.length;i<n;i++)r[i-1]=arguments[i]}var a=void 0;if(a=this._triggerPauseStack){var o=a[a.length-1];if("IS_FLUSHING"!==o[o.length-1])return void o.push(this,e,r)}for(var s=0,u=t.length;s<u;s++){var h=t[s];h&&h.apply(this,r)}r&&F.arrayPool.ret(r)}}function h(e,t){if(-1!==e.indexOf("."))return l.call(this,e,t);var r="_callbackToIndexMapFor_"+e,i=this.hasOwnProperty(r)?this[r]:this[r]=this[r]?new w.a(this[r]):new w.a;if(void 0===i.get(t)){var n="_callbacksFor_"+e,a=this.hasOwnProperty(n)?this[n]:this[n]=this[n]?this[n].slice():[];i.set(t,a.length),a.push(t)}}function d(e,t){if(-1!==e.indexOf("."))return c.call(this,e,t);var r="_callbackToIndexMapFor_"+e,i=this[r];if(i&&void 0!==i.get(t)){var n=this.hasOwnProperty(r)?this[r]:this[r]=this[r]?new w.a(this[r]):new w.a,a="_callbacksFor_"+e;(this.hasOwnProperty(a)?this[a]:this[a]=this[a]?this[a].slice():[])[n.get(t)]=null,n.delete(t)}}function l(e,t,r){var i="_"+e+"_"+F.guidFor(t)+"_"+F.guidFor(r),n="_chainListenerMaintenanceCallback_for"+i;if(!this[n]){var a=e.indexOf("."),o=-1!==a,s=e.substring(a+1),u=s.substring(0,(s.indexOf(".")+1||s.length+1)-1),d=e.substring(0,-1===a?e.length:a),p="_chainListenerPreviousStoredValue_for"+i,f=function(e){var i=r||this;if(u&&o){var n=this[d],a=this[p];n!==a&&(this[p]=n,a&&a.isLPKObservable&&c.call(a,s,t,i),n&&n.isLPKObservable&&l.call(n,s,t,i))}e||t.call(i)};h.call(this,d,f),this.isInitialized&&f.call(this,!0),this[n]=f}}function c(e,t,r){var i="_"+e+"_"+F.guidFor(t)+"_"+F.guidFor(r),n="_chainListenerMaintenanceCallback_for"+i,a=this[n];if(a){var o=e.indexOf("."),s=e.substring(0,-1===o?e.length:o);d.call(this,s,a);var u="_chainListenerPreviousStoredValue_for"+i,h=this[u];if(h&&h.isLPKObservable){this[u]=void 0;var l=e.substring(o+1),p=r||this;c.call(h,l,t,p)}this[n]=void 0}}function p(e,t){h.apply(this,arguments),this.isInitialized&&t.call(this)}function f(e,t){d.apply(this,arguments)}function v(){var e=this._nextObserverId=(this._nextObserverId||0)+1,t="_runtimeObserver"+e,r=F.observer.apply(F.observer,arguments);return r.registerOnDefinition(this,t),r}function m(e){var t=this._metadatas[e];t&&t.invalidateForObject&&t.invalidateForObject(this)}function y(e){return F.resolvePropertyPathFromObject(this,e)}function g(e,t){var r=e.lastIndexOf(".");if(-1===r)return void(this[e]=t);var i=F.resolvePropertyPathFromObject(this,e.slice(0,r));i&&(i[e.slice(r+1)]=t)}function b(){for(var e=F.objectPool.get(),t=0,r=arguments.length;t<r;t++){var i=arguments[t];e[i]=this.getPath(i)}return e}function _(){var e=arguments.length,t=arguments[e-1],r=F.arrayPool.get();if(e>1)for(var i=0;i<e-1;i++)r[i]=arguments[i];else for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&r.push(n);F.Object.prototype.pauseNotifications();for(var a=0,o=r.length;a<o;a++){var s=r[a];this.setPath(s,t[s])}F.Object.prototype.resumeNotifications(),F.arrayPool.ret(r)}function P(){(this.hasOwnProperty("_triggerPauseStack")?this._triggerPauseStack:this._triggerPauseStack=F.arrayPool.get()).push(F.arrayPool.get())}function k(){var e=this.hasOwnProperty("_triggerPauseStack")&&this._triggerPauseStack;if(!e)throw"Unmatched `resumeNotifications` call. Cannot over-resume notifications.";var t=e[e.length-1];x(t),e.pop(),F.arrayPool.ret(t),e.length||(delete this._triggerPauseStack,F.arrayPool.ret(e))}function x(e){e.push("IS_FLUSHING");for(var t=F.objectPool.get(),r=0,i=e.length-1;r<i;r+=3){var n=e[r],a=e[r+1],o=e[r+2],s=F.guidFor(n)+":"+a,u=t[s];void 0!==u&&(e[u]=null),t[s]=o?void 0:r}F.objectPool.ret(t);for(var h=0,d=e.length-1;h<d;h+=3){var l=e[h];if(l){var c=e[h+1],p=e[h+2];p?(p.unshift(c),l.trigger.apply(l,p),F.arrayPool.ret(p)):l.trigger(c)}}}var S=r(39),T=r(17),w=r(16),O=r(36),C="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},F={mixin:function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),i=1;i<t;i++)r[i-1]=arguments[i];for(var n=1,a=arguments.length;n<a;n++){var o=arguments[n];if(o)for(var s in o)o.hasOwnProperty(s)&&(e[s]=o[s])}},instanceOf:function(e,t){return!!e&&(e.constructor===t||F.kindOf(e.constructor,t))},kindOf:function(e,t){if(!(e&&e.isLPKClass&&t&&t.isLPKClass))return!1;do{if(e===t)return!0}while(e=e.superclass);return!1},instanceOrKindOf:function(e,t){return F.instanceOf(e,t)||F.kindOf(e,t)},isHash:function(e){var t=void 0;return!("object"!==(void 0===e?"undefined":C(e))||null===e||(t=e.constructor)&&t!==Object||e.isLPKObject||e.isLPKClass)},arrayPool:S.a,mapPool:S.b,objectPool:S.c,canvasPool:S.d,String:O.a,Array:{mapIntoArray:function(e,t,r){var i=e.length;r.length!==i&&(r.length=i);for(var n=0;n<i;n++)r[n]=t(e[n],n);return r}},resolvePropertyPathFromObject:function(e,t){for(var r=t.indexOf("."),i=0,n=e;-1!==r;){if(!(n=n[t.substring(i,r)]))return;i=r+1,r=t.indexOf(".",i)}return n[t.substring(i)]},InequalityTests:{DEFAULT:function(e,t,r){return e!==t||Array.isArray(e)||F.isHash(e)},STRICT:function(e,t,r){return e!==t},NAN_AWARE:function(e,t,r){return!Object.is(e,t)}},guidFor:T.a,reusableObject:{},emptyArray:[],Object:null,Metadata:null,observer:null,MetadataExtension:null,metadataExtension:null,AccumulatorMetadata:null,accumulator:null,ObserverMetadata:null,Property:null,property:null,ObservableProperty:null,observableProperty:null,ProxyProperty:null,proxyProperty:null,boundFunction:null};F.Object={staticMembers:{isLPKClass:!0,isLPKObservable:!0,isInitialized:!0,create:function(){for(var e=arguments.length,t=Array(e),r=0;r<e;r++)t[r]=arguments[r];var i=Object.create(this.prototype);return i.constructor=this,i.init.apply(i,arguments),i},extend:function(){for(var e=arguments.length,t=Array(e),r=0;r<e;r++)t[r]=arguments[r];var n=Object.create(this);return n.prototype=Object.create(n.prototype),Array.prototype.forEach.call(arguments,i,n),n.superclass=this,n.init(),n},init:function(){},isClassFor:function(e){var t=e&&e.constructor;return!(!t||!this.isSuperclassOf(t))},isSuperclassOf:function(e){var t=this;if(!(e&&e.isLPKClass&&t&&t.isLPKClass))return!1;do{if(e===t)return!0}while(e=e.superclass);return!1},_super:null,_metadatas:{},trigger:u,_listen:h,_observe:p,_unlisten:d,_unobserve:f,observe:v,propertyChanged:m,pauseNotifications:P,resumeNotifications:k,getPath:y,setPath:g,getMultiple:b,setMultiple:_},isLPKObject:!0,isLPKObservable:!0,isInitialized:!1,_metadatas:{},init:function(e){F.mixin(this,e),this._awakenPropertiesWithAccessors()},_awakenPropertiesWithAccessors:function(){var e=F.arrayPool.get(),t=this._metadatas;do{e.push(t)}while(t=Object.getPrototypeOf(t));for(var r,i=F.arrayPool.get(),n=F.arrayPool.get(),a=F.arrayPool.get(),o=F.mapPool.get(),s=e.length-1;r=e[s];s--){for(var u in r)if(r.hasOwnProperty(u)){var h=r[u];if(h.hasAccessors){var d=this[u];if(void 0!==d){var l=o.get(h);void 0!==l&&(i[l]=n[l]=void 0),o.set(h,i.length),i.push(h),n.push(d)}}}a.push(i.length)}this.isInitialized=!0,F.Object.prototype.pauseNotifications();for(var c=0,p=n.length;c<p;c++){var f=n[c];void 0!==f&&i[c].awakenForObjectWithValue(this,f)}F.Object.prototype.resumeNotifications(),F.arrayPool.ret(e),F.arrayPool.ret(i),F.arrayPool.ret(n),F.arrayPool.ret(a),F.mapPool.ret(o)},_super:null,trigger:u,_listen:h,_observe:p,_unlisten:d,_unobserve:f,observe:v,propertyChanged:m,pauseNotifications:P,resumeNotifications:k,getPath:y,setPath:g,getMultiple:b,setMultiple:_},F.Object.staticMembers.prototype=F.Object,F.Object=F.Object.staticMembers,delete F.Object.prototype.staticMembers,Object.defineProperty(F.Object,"sharedInstance",{get:function(){return this.hasOwnProperty("_internalValue_for_sharedInstance")||(this._internalValue_for_sharedInstance=this.create()),this._internalValue_for_sharedInstance},set:function(){throw"Cannot write to a read-only property."}}),F.Metadata=F.Object.extend({registerOnDefinition:function(e,t){e._metadatas[t]=this},unregisterFromDefinition:function(e,t){e._metadatas[t]=void 0}}),F.MetadataExtension=F.Metadata.extend({init:function(e){this._super(),this._extensionParams=e},registerOnDefinition:function(e,t){e._metadatas[t].constructor.extend(this._extensionParams).sharedInstance.registerOnDefinition(e,t)}}),F.metadataExtension=F.MetadataExtension.create.bind(F.MetadataExtension),F.AccumulatorMetadata=F.Metadata.extend({init:function(e){this._super(),this.value=e},registerOnDefinition:function(e,t){var r=e[t];e[t]=this.accumulateValues(e,r,this.value)},accumulateValues:function(e,t,r){if(Array.isArray(t)&&Array.isArray(r))return t.concat(r);if(t&&t.isLPKClass&&F.isHash(r))return t.extend(r);if(r instanceof Function)return r.call(e,t);throw"Cannot use accumulators this way yet."}}),F.accumulator=F.AccumulatorMetadata.create.bind(F.AccumulatorMetadata),F.ObserverMetadata=F.Metadata.extend({staticMembers:{_collector:[]},dependencies:[],observerCallback:function(){throw"Must specify `observerCallback` on observers."},decideRequiresUpdate:F.InequalityTests.DEFAULT,init:function(){if(F.isHash(arguments[0]))this._super.apply(this,arguments);else{var e=Array.prototype.slice.call(arguments),t=e.pop();this._super({dependencies:e,observerCallback:t})}},registerOnDefinition:function(e,t){this._super.apply(this,arguments),this.keyOnObject=t;var r=this;this._invokeObserverCallbackIfNeeded=this._invokeObserverCallbackIfNeeded||(this._invokeObserverCallbackIfNeeded=function(){var e=r.dependencies,i=r.observerCallback,n=r.constructor._collector;n.length=e.length;var a=!1;r._shouldForceNextInvocationOfObserverCallback&&(r._shouldForceNextInvocationOfObserverCallback=!1,a=!0);for(var o=0;o<e.length;o++){var s=e[o],u=this.getPath(s),h="_lastValueSeenByObserver_"+t+"_forDependency_"+s,d=this[h];this[h]=u,!a&&r.decideRequiresUpdate(u,d,s)&&(a=!0),n[o]=u}a&&i.apply(this,n),n.length=0}),e[this.keyOnObject]=e[this.keyOnObject]||(e[this.keyOnObject]=function(){r._shouldForceNextInvocationOfObserverCallback=!0,r._invokeObserverCallbackIfNeeded.call(this)});for(var i=this.dependencies,n=0;n<i.length;n++)e.isInitialized?e._observe(i[n],this._invokeObserverCallbackIfNeeded):e._listen(i[n],this._invokeObserverCallbackIfNeeded)},unregisterFromDefinition:function(e,t){this._super.apply(this,arguments);for(var r=this.dependencies,i=0;i<r.length;i++)e._unlisten(r[i],this._invokeObserverCallbackIfNeeded)}}),F.observer=F.ObserverMetadata.create.bind(F.ObserverMetadata),F.Property=F.Metadata.extend({staticMembers:{extend:function(e){return 1!==arguments.length||F.isHash(e)?this._super.apply(this,arguments):this._super({defaultValue:e})}},hasAccessors:!0,readOnly:!1,defaultValue:void 0,get:null,set:null,keyOnObject:null,storageKeyOnObject:null,_defaultGetter:function(e){return e},_defaultSetter:function(e){return e},_internalGetterForObject:function(e){return this.get.call(e,e[this.storageKeyOnObject])},_internalSetterForObject:function(e,t){e[this.storageKeyOnObject]=this.set.call(e,t)},init:function(e){var t=this;if(1!==arguments.length||F.isHash(e)?this._super.apply(this,arguments):this._super({defaultValue:e}),this.get||(this.get=this._defaultGetter),this.readOnly){if(this.set)throw"Cannot include both `readOnly` and `set`.";this.set=function(e){if(t._isAwakeningInReadOnlyMode)return t._isAwakeningInReadOnlyMode=!1,e;throw"Cannot write to a read-only property"}}else this.set||(this.set=this._defaultSetter)},registerOnDefinition:function(e,t){this._super.apply(this,arguments),this.keyOnObject=t;var r=this.storageKeyOnObject="_internalValue_for_"+t;this._internalGetterForObject=this._internalGetterForObject.bind(this),this._internalSetterForObject=this._internalSetterForObject.bind(this);var i=this;Object.defineProperty(e,t,{get:function(){return this.isInitialized?i._internalGetterForObject(this):this[r]},set:function(e){if(!this.isInitialized)return void(this[r]=e);i._internalSetterForObject(this,e)}}),e[t]=this.defaultValue},unregisterFromDefinition:function(e,t){F.reusableObject[t]=void 0;var r=Object.getOwnPropertyDescriptor(F.reusableObject,t);delete F.reusableObject[t],Object.defineProperty(e,t,r),delete e["_internalValue_for_"+t],this._super.apply(this,arguments)},awakenForObjectWithValue:function(e,t){this.readOnly&&(this._isAwakeningInReadOnlyMode=!0),t instanceof Function&&(t=t.call(e)),e[this.keyOnObject]=t}}),F.property=F.Property.extend.bind(F.Property),F.ObservableProperty=F.Property.extend({isCacheable:!1,dependencies:[],writeDependencies:[],decideRequiresUpdate:F.InequalityTests.DEFAULT,_internalSetterForObject:function(e){this._super.apply(this,arguments),this.invalidateForObject(e)},_internalGetterForObject:function(e){if(!this.isCacheable)return this._super.apply(this,arguments);var t=this.cacheExistenceKeyOnObject;if(e[t])return e[this.cacheStorageKeyOnObject];var r=this._super.apply(this,arguments);return e[t]=!0,e[this.cacheStorageKeyOnObject]=r,r},invalidateForObject:function(e){e[this.cacheExistenceKeyOnObject]=!1,e[this.cacheStorageKeyOnObject]=void 0,e.trigger(this.keyOnObject)},registerOnDefinition:function(e,t){this._super.apply(this,arguments);var r=this;this.cacheStorageKeyOnObject="_cacheStorageForProperty_"+t,this.cacheExistenceKeyOnObject="_cacheExistenceForProperty_"+t,F.observer({dependencies:this.dependencies,observerCallback:function(){r.invalidateForObject(this)},decideRequiresUpdate:this.decideRequiresUpdate}).registerOnDefinition(e,"_dependencyObserverForProperty_"+t),this.didChange&&F.observer({dependencies:[t],observerCallback:this.didChange,decideRequiresUpdate:this.decideRequiresUpdate}).registerOnDefinition(e,"_didChangeObserverForProperty_"+t)}}),F.observableProperty=F.ObservableProperty.extend.bind(F.ObservableProperty),F.ProxyProperty=F.ObservableProperty.extend({proxyPath:null,decode:function(e){return e},encode:function(e){return e},init:function(e){var t="string"==typeof e?e:e.proxyPath;if(!t)throw"A proxyPath must be configured on a ProxyProperty.";this.dependencies=[t];var r=this;this.get=function(){return r.decode(this.getPath(r.proxyPath))},e&&e.readOnly||(this.set=function(e){this.setPath(r.proxyPath,r.encode(e))}),"string"==typeof e?this._super({proxyPath:e}):this._super.apply(this,arguments)}}),F.proxyProperty=F.ProxyProperty.create.bind(F.ProxyProperty),F.boundFunction=function(e){return F.property(function(){return e.bind(this)})},t.a=F},function(e,t,r){"use strict";function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var n=function(){function e(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,r,i){return r&&e(t.prototype,r),i&&e(t,i),t}}(),a=navigator.userAgent.toLowerCase(),o=/\sedge\//.test(a),s=function(){function e(){i(this,e)}return n(e,null,[{key:"isEdge",get:function(){return o}},{key:"isChrome",get:function(){return e._isChrome}},{key:"isSafari",get:function(){return e._isSafari}},{key:"isFirefox",get:function(){return e._isFirefox}},{key:"isIE",get:function(){return e._isIE}},{key:"isIOS",get:function(){return e._isIOS}}]),e}();t.a=s,s._isChrome=!s.isEdge&&/chrome/.test(a),s._isSafari=!s.isEdge&&!s.isChrome&&/safari/.test(a),s._isFirefox=!s.isEdge&&!s.isChrome&&!s.isSafari&&/firefox/.test(a),s._isIE=!s.isEdge&&!s.isChrome&&!s.isSafari&&!s.isFirefox&&/trident|msie/.test(a),s._isIOS=!!navigator.userAgent.match(/\b(iPad|iPhone|iPod)\b.*\bOS \d+_\d+/i)},function(e,t,r){"use strict";var i=r(12),n={debug:function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];i.a&&console.debug.apply(console,arguments)},log:function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];i.a&&console.log.apply(console,arguments)},info:function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),n=1;n<t;n++)r[n-1]=arguments[n];i.a&&console.info.apply(console,arguments)},warn:function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),i=1;i<t;i++)r[i-1]=arguments[i];console.warn.apply(console,arguments)},error:function(e){for(var t=arguments.length,r=Array(t>1?t-1:0),i=1;i<t;i++)r[i-1]=arguments[i];console.error.apply(console,arguments)}};t.a=n},function(e,t,r){"use strict";r.d(t,"a",function(){return i});var i;!function(e){e[e.FAILED_TO_DOWNLOAD_RESOURCE=0]="FAILED_TO_DOWNLOAD_RESOURCE",e[e.PHOTO_FAILED_TO_LOAD=1]="PHOTO_FAILED_TO_LOAD",e[e.VIDEO_FAILED_TO_LOAD=2]="VIDEO_FAILED_TO_LOAD"}(i||(i={}))},function(e,t,r){"use strict";var i=r(0),n=i.a.Object.extend({element:null,_lpk_isView:!0,tagName:"div",eventDispatchingElement:null,init:function(e){e?this.element=e:this.tagName&&(this.element=document.createElement(this.tagName)),this._super()},attachInto:function(e,t,r){if(!this.element)return void(this.parentView=e);t||(t=e.element),r&&r._lpk_isView&&(r=r.element),r?t.insertBefore(this.element,r):t.appendChild(this.element),this.parentView=e},detach:function(){this.element&&this.element.parentNode&&this.element.parentNode.removeChild(this.element),this.parentView=null},dispatchEvent:function(e){var t=this.eventDispatchingElement||this.element;if(!t)throw"Cannot dispatch an event from a view with no DOM element.";t.dispatchEvent.call(t,e)},parentView:null});t.a=n},function(e,t,r){"use strict";r.d(t,"a",function(){return i});var i={FULL:"full",HINT:"hint"}},function(e,t,r){"use strict";function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function n(e,t){if(arguments.length>=3||"string"==typeof arguments[0]&&"string"==typeof arguments[1]){var r=arguments[0],i=arguments[1],_=arguments[2],P=arguments[3]||(r||i?{}:void 0);return r&&(P.photoSrc=r),i&&(P.videoSrc=i),u.a.warn("LivePhotosKit.Player: Creating a new Player using arguments of the form 'photoSrc, videoSrc, [targetElement, [options]]' is deprecated. Instead, consider the new signature, '[targetElement, [options]]'. If necessary, either assign `photoSrc` and/or `videoSrc` after Player creation, or provide them as named parameters in an `options` hash."),P?n(_,P):_?n(_):n()}var k=e||document.createElement("div");if(k.__isLPKPlayer__)return k;y.value=!0,Object.defineProperty(k,"__isLPKPlayer__",y);var x=s.a.objectPool.get();for(var S in t)Object.prototype.hasOwnProperty.call(t,S)&&(c[S]===d?x[S]=t[S]:u.a.warn("LivePhotosKit.Player: Initial configuration for `"+S+"` was ignored, because the property is not a writable property."));var T=o.a.create(k,x);s.a.objectPool.ret(x),x=null;for(var w,O,C=0;(w=p[C])&&(O=m[C]);C++)!function(e,t,r){r===h?(y.value=T[t].bind(T),Object.defineProperty(k,t,y)):(g.set=r===d?function(e){T[t]=e}:function(){},g.get=function(){return T[t]},Object.defineProperty(k,t,g))}(0,w,O);y.value=function(){var e=arguments.length,t=arguments[e-1];if(e<1||!(t instanceof Function))throw new Error("Invalid arguments passed to `observe`. Form: key, [key, …], callback.");for(var r=s.a.arrayPool.get(),i=0,n=e;i<n;i++)r[i]=arguments[i];for(var a=0,o=e-1;a<o;a++){var u=c[r[a]];if(u!==d&&u!==l)throw new Error("Can't observe non-observable property '"+r[a]+"'.")}r[e-1]=t.bind(this);var h=T.observe.apply(T,r);return s.a.arrayPool.ret(r),new b(h,T)},Object.defineProperty(k,"observe",y);for(var w,O,F,C=0;(w=p[C])&&(O=m[C])&&(F=v[C]);C++)if(O===d){var R=k.getAttribute(F);R&&(T[w]=a(R))}var D=k.setAttribute;y.value=function(e,t){var r=f[e];if(!r)return void D.apply(this,arguments);this[r]=a(t)},Object.defineProperty(k,"setAttribute",y);var A=k.removeAttribute;y.value=function(e){var t=f[e];if(!t)return A.apply(this,arguments);this[t]=null},Object.defineProperty(k,"removeAttribute",y);for(var L,I,M,E=0;(L=p[E])&&(I=m[E])&&(M=v[E]);E++){(function(e,t,r,i){if(r!==d&&r!==l)return"continue";k.observe(t,function(e){void 0===e||null===e||"string"!=typeof e&&+e!==e&&"boolean"!=typeof e?A.call(this,i):D.call(this,i,String(e))})})(0,L,I,M)}return""!==k.getAttribute("data-live-photo")&&k.setAttribute("data-live-photo",""),y.value=T,Object.defineProperty(k,"__internalLPKPlayer__",y),y.value=void 0,g.set=g.get=void 0,k}function a(e){var t=parseFloat(e);if(+t===t)return t;var r="true"===e||"false"!==e&&void 0;return!!r===r?r:e}var o=r(22),s=r(0),u=r(2),h="method",d="property",l="read_only_property",c={play:h,pause:h,stop:h,toggle:h,beginFinishingPlaybackEarly:h,isPlaying:l,wantsToPlay:l,currentTime:d,renderedTime:l,duration:l,playbackStyle:d,updateSize:h,photoWidth:l,photoHeight:l,videoWidth:l,videoHeight:l,proactivelyLoadsVideo:d,photoSrc:d,photoMimeType:d,videoSrc:d,videoMimeType:d,metadataVideoSrc:d,photo:d,video:d,photoTime:d,frameTimes:d,videoRotation:d,canPlay:l,loadProgress:l,errors:l,showsNativeControls:d,observe:h};delete c.observe;var p=function(){var e=[];for(var t in c)c.hasOwnProperty(t)&&e.push(t);return e}(),f={},v=p.map(function(e){var t="data-"+s.a.String.hyphenate(e);return f[t]=e,t}),m=p.map(function(e){return c[e]}),y={enumerable:!1,configurable:!1,writable:!1},g={enumerable:!1,configurable:!1},b=function e(t,r){i(this,e),this.fire=function(){r[t.keyOnObject]()},this.disconnect=function(){t.unregisterFromDefinition(r)},this.connect=function(){t.registerOnDefinition(r)}};t.a=n},function(e,t,r){"use strict";var i=r(0),n=r(8),a=r(31),o=r(32),s=i.a.Object.extend({layerName:null,renderLayerClass_dom:null,renderLayerMixin:{},init:function(e){this._super(),this.renderLayerMixin=e},getRenderLayer:function(e,t){return this["renderLayerClass_"+e.approach].extend(this.renderLayerMixin,{layerName:this.layerName}).create(e,t)}}),u=s.extend({renderLayerClass_dom:a.a}),h=s.extend({renderLayerClass_dom:o.a}),d=i.a.Object.extend({staticMembers:{PhotoIngredient:u,VideoIngredient:h,computedStyle:n.a.computedStyle,registerRecipeWithPlaybackStyle:function(e,t){(this._recipesByPlaybackStyle||(this._recipesByPlaybackStyle={}))[t]=e},recipeForPlaybackStyle:function(e){return this._recipesByPlaybackStyle?this._recipesByPlaybackStyle[e]:void 0}},correspondingPlaybackStyle:null,get name(){return"recipe_for_playbackStyle_"+this.correspondingPlaybackStyle},minimumShortenedDuration:0,spontaneousFinishDuration:0,ingredients:null,init:function(e){this.ingredients=[],this._super();for(var t in e)if(e.hasOwnProperty(t)){var r=e[t];this[t]=r,s.isClassFor(r)&&(r.layerName=t,this.ingredients.push(r))}if(!this.correspondingPlaybackStyle)throw new Error("Recipe is missing a correspondingPlaybackStyle. All Recipes require a matching PlaybackStyle enum value for external reference.");d.registerRecipeWithPlaybackStyle(this,this.correspondingPlaybackStyle)},getRenderLayers:function(e){for(var t,r=[],i=0;t=this.ingredients[i];i++)t.isDisabled||r.push(t.getRenderLayer(e,this));return r},calculateAnimationDuration:function(e,t){return e||0},register:function(){}});t.a=d},function(e,t,r){"use strict";var i=r(4),n=r(0),a=i.a.extend({staticMembers:{computedStyle:function(e){return e._lpk_isComputedStyle=!0,e}},recipe:n.a.observableProperty(),renderer:n.a.observableProperty(),duration:n.a.proxyProperty("renderer.duration"),canRender:n.a.observableProperty(!1),computedStyles:n.a.property(function(){return[]}),displayWidth:0,displayHeight:0,init:function(e,t){this.renderer=e,this.recipe=t,this._super();for(var r in this){var i=this[r];i&&i._lpk_isComputedStyle&&this.computedStyles.push({styleKey:r,getter:i})}},updateSize:function(e,t){if(!arguments.length)return this.updateSize(this.displayWidth,this.displayHeight);this.displayWidth=e,this.displayHeight=t},setUpForRender:function(){},tearDownFromRender:function(){this.reduceMemoryFootprint()},reduceMemoryFootprint:function(){},_canRenderDidChange:n.a.observer("canRender",function(e){e?(this.setUpForRender(),this.updateSize()):this.tearDownFromRender()}),prepareToRenderAtTime:function(){return!0},canRenderAtTime:function(){return!0},renderAtTime:function(e){if(!arguments.length)return this.renderAtTime(this._lastRenderedTime);this._lastRenderedTime=e;for(var t,r=0;t=this.computedStyles[r];r++)t.value=t.getter.call(this,e);this.renderStyles(this.computedStyles)},renderStyles:function(e){},dispose:function(){this.detach()}});t.a=a},function(e,t,r){"use strict";var i=r(18),n=r(47);t.a={LIVEPHOTOSKIT_LOADED:"livephotoskitloaded",BUILD_VERSION:i.a,VERSION:n.a,URL_PREFIX:"https://cdn.apple-livephotoskit.com"}},function(e,t,r){"use strict";function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var n=r(4),a=r(42),o=r(35);r.d(t,"b",function(){return u}),r.d(t,"a",function(){return d});var s=function(){function e(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,r,i){return r&&e(t.prototype,r),i&&e(t,i),t}}(),u=n.a.extend({badgeView:null,init:function(){var e=this;this._super(),this._createBadgeView(),o.a(function(){return e.badgeView.redraw()})},_createBadgeView:function(){this.badgeView=new d,this.element.appendChild(this.badgeView.element);var e=this.badgeView.element.style;e.top="10px",e.right="10px",e.position="absolute",e.zIndex=4},updateToRendererLayout:function(e,t,r,i){var n=this.badgeView,a=n.element.style;a.left=e+r-n.width-10+"px",a.top=t+10+"px",a.right=""},redraw:function(){this.badgeView.redraw()}}),h={element:null,label:"LIVE",labelPadding:6,leftPadding:5,height:25,backgroundColor:"rgba(255, 255, 255, 0.7)",itemColor:"rgb(0, 0, 0)",fontSize:8.5,borderRadius:5,dottedRadius:8.5,innerRadius:5.25,zIndex:4,shouldAnimateProgressRing:!0,progressRingAnimationSpeed:300,shouldAddEventListeners:!0,configurePlayAction:r.i(a.a)(),configureStopAction:r.i(a.a)()},d=function(){function e(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{};i(this,e),this._setInstanceProps(t),this._createCanvas(),this.redraw(),this.shouldAddEventListeners&&this._addEventListeners()}return s(e,[{key:"redraw",value:function(){var e=this.progress;e>0&&this.shouldAnimateProgressRing?this._animateProgressRing():this._redraw(e)}},{key:"appendTo",value:function(e){e.appendChild(this.element)}},{key:"_createCanvas",value:function(){var e=this.element;if(e){if("canvas"!==e.tagName.toLowerCase())throw new Error("Backing element for LivePhotoBadge needs to be an HTMLCanvasElement.")}else e=this.element=document.createElement("canvas");e.classList.add("lpk-badge"),this._context=e.getContext("2d")}},{key:"_setCanvasSize",value:function(){var e=this.element,t=o.b(),r=this.height,i=this.width;e.height=r*t,e.width=i*t,e.style.height=r+"px",e.style.width=i+"px"}},{key:"_setInstanceProps",value:function(e){var t={};for(var r in h)t.hasOwnProperty.call(h,r)&&(this[r]=e.hasOwnProperty(r)?e[r]:h[r]);this.defaultProps=h}},{key:"_redraw",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:0;this._setCanvasSize(),this._context.clearRect(0,0,this.width,this.height),this._drawBackground(),this._drawLabel(),this.shouldShowError||(this._drawInnerCircle(),this._drawPlayArrow()),this.shouldShowError?(this._drawProgressRing(1),this._drawErrorSlash()):this.progress>0?this._drawProgressRing(e):this._drawDottedCircle()}},{key:"_drawBackground",value:function(){var e=o.b(),t=this._context,r=this.borderRadius*e,i=this.width*e,n=this.height*e;t.beginPath(),t.moveTo(r,0),t.lineTo(i-r,0),t.quadraticCurveTo(i,0,i,r),t.lineTo(i,n-r),t.quadraticCurveTo(i,n,i-r,n),t.lineTo(r,n),t.quadraticCurveTo(0,n,0,n-r),t.lineTo(0,r),t.quadraticCurveTo(0,0,r,0),t.closePath(),t.fillStyle=this.backgroundColor,t.fill()}},{key:"_drawDottedCircle",value:function(){for(var t=e.numberOfDots,r=this.dottedRadius*o.b(),i=0;i<t;i++){var n=this.x0+r*Math.cos(2*Math.PI*i/t),a=this.y0+r*Math.sin(2*Math.PI*i/t);this._drawDot(n,a)}}},{key:"_drawDot",value:function(e,t){var r=this._context,i=1===o.b()?1:1.25;r.beginPath(),r.arc(e,t,i,0,2*Math.PI),r.fillStyle=this.itemColor,r.fill()}},{key:"_drawInnerCircle",value:function(){var e=o.b(),t=this._context,r=this.innerRadius*e;t.beginPath(),t.arc(this.x0,this.y0,r,0,2*Math.PI),t.lineWidth=1===e?1.25:1.5,t.strokeStyle=this.itemColor,t.stroke()}},{key:"_drawPlayArrow",value:function(){var e=o.b(),t=this._context,r=5*e,i=4*e,n=this.x0+.5*e,a=this.y0;t.beginPath(),t.moveTo(n-i/2,a-r/2),t.lineTo(n+i/2,a),t.lineTo(n-i/2,a+r/2),t.fillStyle=this.itemColor,t.fill()}},{key:"_drawLabel",value:function(){var e=o.b(),t=this._context,r=(this.leftPadding+2*this.dottedRadius+this.labelPadding)*e,i=(this.height/2+4.5)*e;t.fillStyle=this.itemColor,t.font=this.fontStyle,t.fillText(this.label,r,i)}},{key:"_drawProgressRing",value:function(e){var t=o.b(),r=this._context,i=this.dottedRadius*t,n=2*Math.PI*.75,a=(.75+e)*(2*Math.PI);r.beginPath(),r.arc(this.x0,this.y0,i,n,a,!1),r.lineWidth=1.5*t,r.strokeStyle=this.itemColor,r.stroke()}},{key:"_drawErrorSlash",value:function(){var e=o.b(),t=this._context,r=this.dottedRadius*e,i=r*Math.sqrt(2)/2;t.beginPath(),t.moveTo(this.x0+i,this.y0-i),t.lineTo(this.x0-i,this.y0+i),t.lineWidth=1.5*e,t.strokeStyle=this.itemColor,t.stroke()}},{key:"_animateProgressRing",value:function(){var e=this,t=this.progress,r=this._previousProgress||0,i=Math.abs(t-r),n=t<r;n&&(t=r,r=this.progress);for(var a=i*this.progressRingAnimationSpeed,o=a/(1e3/60),s=i/o,u=[],h=0,d=o;h<d;h++)u.push(r+h*s);u[u.length-1]=t,n&&u.reverse();!function t(){var r=u.shift();e._redraw(r),u.length&&window.requestAnimationFrame(t),1===r&&window.setTimeout(function(){e.progress=0},.25*e.progressRingAnimationSpeed)}()}},{key:"_addEventListeners",value:function(){var e=this,t=this.element,r=void 0;t.addEventListener("mouseenter",function(){r=window.setTimeout(function(){e.configurePlayAction()},0)}),t.addEventListener("mouseleave",function(){r&&window.clearTimeout(r),e.configureStopAction()})}},{key:"width",get:function(){if(this._width)return this._width;var e=this._context;if(!e)return 0;e.font=this.fontStyle;var t=this._textMetrics=e.measureText(this.label);return this._width=this.leftPadding+2*this.dottedRadius+2*this.labelPadding+Math.ceil(t.width/o.b())}},{key:"fontStyle",get:function(){return"bold "+this.fontSize*o.b()+'pt/1 system, -apple-system, BlinkMacSystemFont, "Helvetica Neue", Helvetica'}},{key:"x0",get:function(){return(this.dottedRadius+this.leftPadding)*o.b()}},{key:"y0",get:function(){return this.height/2*o.b()}},{key:"progress",set:function(e){"number"==typeof e&&(0!==e&&1!==e||(this._previousProgress=null),this._previousProgress=this._progress,this._progress=e,this.redraw())},get:function(){return this._progress}},{key:"shouldShowError",set:function(e){this._shouldShowError=!!e,this._redraw()},get:function(){return this._shouldShowError}}],[{key:"numberOfDots",get:function(){return 1===o.b()?17:26}}]),e}()},function(e,t,r){"use strict";function i(e){return function(t){return new CustomEvent(e,{detail:t})}}var n=r(9);r.d(t,"a",function(){return a}),r.d(t,"b",function(){return o}),r.d(t,"c",function(){return s}),r.d(t,"f",function(){return u}),r.d(t,"d",function(){return h}),r.d(t,"e",function(){return d}),function(){function e(e,t){t=t||{bubbles:!1,cancelable:!1,detail:void 0};var r=document.createEvent("CustomEvent");return r.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),r}if("function"==typeof window.CustomEvent)return!1;e.prototype=window.Event.prototype,window.CustomEvent=e}();var a=i(n.a.LIVEPHOTOSKIT_LOADED),o=i("canplay"),s=i("ended"),u=i("error"),h=i("photoload"),d=i("videoload")},function(e,t,r){"use strict";var i=/_lpk_debug=true/i;t.a=i.test(window.location.search)||i.test(window.location.hash)},function(e,t,r){"use strict";var i=r(25),n=r(0),a=r(3),o=i.a.extend({mimeType:n.a.observableProperty({dependencies:["_mimeTypeFromXHR"],get:function(e){return this._mimeTypeFromXHR||e||null}}),_mimeTypeFromXHR:n.a.observableProperty(),requiresMimeTypeForRawArrayBufferSrc:!0,exposedMimeTypeKeyForErrorStrings:"mimeType",exposedSrcKeyForErrorStrings:"src",abortCurrentLoad:function(){this.__xhr&&(this._detachXHR(),this._xhr.abort()),this._mimeTypeFromXHR=null,this.abortCurrentSecondaryLoad()},loadSrc:function(e){if("string"==typeof e){this._mimeTypeFromXHR=null,this._attachXHR();var t=this._xhr;t.open("GET",e),t.responseType="arraybuffer",t.send(null)}else if(e instanceof ArrayBuffer){if(!this.mimeType&&this.requiresMimeTypeForRawArrayBufferSrc)throw new Error("MIME Type must be assigned to `"+this.exposedMimeTypeKeyForErrorStrings+"` prior to assigning a raw ArrayBuffer to `"+this.exposedSrcKeyForErrorStrings+"`.");this.beginSecondaryLoad(e,this.mimeType)}},get _xhr(){var e=this.__xhr;return e||(e=this.__xhr=new XMLHttpRequest),e},_detachXHR:function(){var e=this._xhr;e.removeEventListener("progress",this._xhrProgress),e.removeEventListener("readystatechange",this._xhrReadyStateChanged)},_attachXHR:function(){var e=this._xhr;e.addEventListener("progress",this._xhrProgress),e.addEventListener("readystatechange",this._xhrReadyStateChanged)},_xhrReadyStateChanged:function(){if("loading"===this.state){if(this._xhr.readyState>=2&&200!==this._xhr.status){var e=new Error("Failed to download resource from URL assigned to '"+this.exposedSrcKeyForErrorStrings+"'.");return e.errCode=a.a.FAILED_TO_DOWNLOAD_RESOURCE,this.loadDidFail(e)}return 4===this._xhr.readyState&&200===this._xhr.status?this._xhrLoadDidFinish():void 0}},_xhrProgress:function(e){if(e&&e.total){var t=(+e.loaded||0)/e.total;+t===t&&(this.progress=Math.max(0,Math.min(1,t)))}},_xhrLoadDidFinish:function(){this._mimeTypeFromXHR=this._xhr.getResponseHeader("Content-Type"),this.beginSecondaryLoad(this._xhr.response,this.mimeType)},beginSecondaryLoad:function(e,t){this._defaultSecondaryLoadTimeout=setTimeout(this.loadDidSucceed.bind(this,e),0)},abortCurrentSecondaryLoad:function(){this._defaultSecondaryLoadTimeout&&(clearTimeout(this._defaultSecondaryLoadTimeout),this._defaultSecondaryLoadTimeout=null)},init:function(){this._xhrReadyStateChanged=this._xhrReadyStateChanged.bind(this),this._xhrProgress=this._xhrProgress.bind(this),this._super()}});t.a=o},function(e,t,r){"use strict";var i={setUpForRender:function(){this.attachInto(this.renderer)},tearDownFromRender:function(){this.detach(),this._super()},renderStyles:function(e){for(var t,r=0;t=e[r];r++)this.element.style[t.styleKey]=t.value}};t.a=i},function(e,t,r){"use strict";var i=r(1);t.a=i.a.isEdge||i.a.isIE},function(e,t,r){"use strict";function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var n=function(){function e(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,r,i){return r&&e(t.prototype,r),i&&e(t,i),t}}(),a=function(){function e(t){var r=this;i(this,e),this._k=[],this._v=[],t&&t._k.forEach(function(e){r.set(e,t.get(e))})}return n(e,[{key:"_indexOfKey",value:function(e){return this._k.indexOf(e)}},{key:"get",value:function(e){var t=this._indexOfKey(e);return-1===t?void 0:this._v[t]}},{key:"set",value:function(e,t){var r=this._indexOfKey(e);return-1===r&&(r=this._k.push(e)-1),this._v[r]=t,this}},{key:"delete",value:function(e){var t=this._indexOfKey(e);return-1!==t&&(this._k.splice(t,1),this._v.splice(t,1),!0)}},{key:"clear",value:function(){this._k.length>0&&(this._k.length=0,this._v.length=0)}}]),e}();t.a=a},function(e,t,r){"use strict";function i(e){if(null===e)return"_null";if(void 0===e)return"_undefined";if(e.hasOwnProperty("_LPKGUID"))return e._LPKGUID;var t=void 0===e?"undefined":n(e);switch(t){case"number":Object.is(e,-0)&&(e="-0");case"string":case"boolean":return t+e;case"object":case"function":o++;var r=t+o;return a.value=r,Object.defineProperty(e,"_LPKGUID",a),r;default:throw"unrecognized object type"}}t.a=i;var n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},a={value:"",enumerable:!1,writable:!1,configurable:!1},o=0},function(e,t,r){"use strict";t.a="17DProjectDev82"},function(e,t,r){"use strict";var i=r(23),n=r(27),a=r(29),o=r(30),s=r(7),u=r(0),h=r(4),d=r(2);a.a.register(),o.a.register();var l=h.a.extend({approach:"",recipe:u.a.observableProperty({defaultValue:a.a,didChange:function(){this.hasRecipeChangedRecently=!0,this.setUpRenderLayers()}}),playbackStyle:u.a.observableProperty({dependencies:["recipe"],get:function(){var e=this.recipe;return e&&e.correspondingPlaybackStyle||null},writeDependencies:["recipe"],set:function(e){var t=s.a.recipeForPlaybackStyle(e);t&&(this.recipe=t)}}),duration:u.a.observableProperty({dependencies:["recipe","provider.videoDuration","provider.photoTime"],get:function(e){var t=this.recipe;if(!t)return 0;var r=this.provider;return Math.max(0,Math.min(e||1/0,t.calculateAnimationDuration(r.videoDuration,r.photoTime)))}}),displayWidth:0,displayHeight:0,get backingWidth(){return Math.round(this.displayWidth*devicePixelRatio)},get backingHeight(){return Math.round(this.displayHeight*devicePixelRatio)},get renderLayerWidth(){return this.displayWidth},get renderLayerHeight(){return this.displayHeight},get videoWidth(){return this.videoDecoder.videoWidth},get videoHeight(){return this.videoDecoder.videoHeight},photoWidth:u.a.proxyProperty("photo.width"),photoHeight:u.a.proxyProperty("photo.height"),photo:u.a.proxyProperty("provider.photo"),video:u.a.proxyProperty("provider.video"),photoTime:u.a.proxyProperty("provider.photoTime"),frameTimes:u.a.proxyProperty("provider.frameTimes"),currentTime:u.a.observableProperty({defaultValue:0,dependencies:["duration"],get:function(e){return Math.min(this.duration||0,Math.max(0,e||0))},didChange:function(e){this.prepareToRenderAtTime(e)}}),canRenderCurrentTime:u.a.observableProperty({readOnly:!0,dependencies:["currentTime"],get:function(){return this.canRenderAtTime(this.currentTime)}}),_currentTimeRenderObserver:u.a.observer("currentTime","canRenderCurrentTime",function(e,t){t&&(this.renderedTime=e)}),renderedTime:u.a.observableProperty({defaultValue:0,didChange:function(e){this.renderAtTime(e),this.currentTime=e}}),areAllRenderLayersPrepared:u.a.observableProperty({defaultValue:!1}),hasRecipeChangedRecently:u.a.observableProperty({defaultValue:!1,set:function(e){return this._recipeChangeTimeout&&(clearTimeout(this._recipeChangeTimeout),this._recipeChangeTimeout=null),e&&(this._recipeChangeTimeout=setTimeout(this._unsetHasRecipeChangedRecently,100)),e}}),_unsetHasRecipeChangedRecently:u.a.boundFunction(function(){this.hasRecipeChangedRecently=!1}),isFullyPreparedForPlayback:u.a.observableProperty({readOnly:!0,dependencies:["video","areAllRenderLayersPrepared","hasRecipeChangedRecently","photoTime","frameTimes"],get:function(){return Boolean(this.video&&this.areAllRenderLayersPrepared&&!this.hasRecipeChangedRecently&&this.photoTime&&Array.isArray(this.frameTimes))}}),cannotRenderDueToMissingPhotoTimeOrFrameTimes:u.a.observableProperty({readOnly:!0,dependencies:["video","areAllRenderLayersPrepared","hasRecipeChangedRecently","photoTime","frameTimes"],get:function(){return Boolean(this.video&&this.areAllRenderLayersPrepared&&!this.hasRecipeChangedRecently&&(!this.photoTime||!Array.isArray(this.frameTimes)))}}),renderLayers:u.a.property(function(){return[]}),videoDecoder:u.a.observableProperty(function(){return this._videoDecoderClass.create({owner:this})}),_videoDecoderClass:i.a.extend({owner:u.a.observableProperty(),provider:u.a.proxyProperty("owner.provider")}),provider:u.a.observableProperty(function(){return n.a.create()}),init:function(){this._super(),this.element.className=((this.element.className||"")+" lpk-live-photo-renderer").trim(),this.element.style.position="absolute",this.element.style.overflow="hidden",this.element.style.textAlign="left"},updateSize:function(e,t){if(!arguments.length)return void(this.displayWidth&&this.displayHeight&&this.updateSize(this.displayWidth,this.displayHeight));this.displayWidth=e=Math.round(e),this.displayHeight=t=Math.round(t),this.element.style.width=e+"px",this.element.style.height=t+"px";for(var r,i=0;r=this.renderLayers[i];i++)r.updateSize(this.renderLayerWidth,this.renderLayerHeight)},_imageOrVideoDidEnterOrLeave:u.a.observer("videoDecoder.canProvideFrames","photo",function(){this.prepareToRenderAtTime(this.currentTime)}),prepareToRenderAtTime:u.a.boundFunction(function(e){this.propertyChanged("canRenderCurrentTime");for(var t,r=!0,i=0;t=this.renderLayers[i];i++)r=t.prepareToRenderAtTime(e)&&r;this.areAllRenderLayersPrepared=r}),canRenderAtTime:function(e){if(0===e)return!0;if(!this.duration&&e)return!1;for(var t,r=!0,i="",n=0;t=this.renderLayers[n];n++)t.canRenderAtTime(e)||(r=!1,i+=(i?", ":"Cannot render; waiting for ")+t.layerName);return i&&d.a.log(i+"."),r},renderAtTime:function(e){if(this.duration)for(var t,r=0;t=this.renderLayers[r];r++)t.renderAtTime(e)},getNewRenderLayers:function(){return this.recipe.getRenderLayers(this)},setUpRenderLayers:function(){var e=this.renderLayers;this.renderLayers=this.getNewRenderLayers(),this.updateSize(),this.currentTime=0,this.prepareToRenderAtTime(0),e&&this._cleanUpRenderLayers(e)},_cleanUpRenderLayers:function(e){for(var t,r=0;t=e[r];r++)t.dispose()},reduceMemoryFootprint:function(){for(var e,t=0;e=this.renderLayers[t];t++)e.reduceMemoryFootprint()},_clearRetainedFramesWhenNecessary:u.a.observer("provider.videoRotation","provider.frameTimes",function(){this.reduceMemoryFootprint(),this.prepareToRenderAtTime(this.currentTime)})});t.a=l},function(e,t,r){"use strict";var i=r(19),n=i.a.extend({approach:"dom"});t.a=n},function(e,t,r){"use strict";Object.defineProperty(t,"__esModule",{value:!0});var i=r(9),n=r(11),a=r(10);r.d(t,"LivePhotoBadge",function(){return a.a});var o=r(6);r.d(t,"Player",function(){return o.a});var s=r(5);r.d(t,"PlaybackStyle",function(){return s.a});var u=r(3);r.d(t,"Errors",function(){return u.a}),r.d(t,"BUILD_VERSION",function(){return h}),r.d(t,"VERSION",function(){return d}),r.d(t,"LIVEPHOTOSKIT_LOADED",function(){return l});var h=i.a.BUILD_VERSION,d=i.a.VERSION,l=i.a.LIVEPHOTOSKIT_LOADED,c="undefined"!=typeof window&&"undefined"!=typeof document;if(c){var p=window.document;setTimeout(function(){return p.dispatchEvent(r.i(n.a)())});if(p.styleSheets&&document.head){for(var f=null,v=null,m=0;m<p.styleSheets.length;++m)try{var y=p.styleSheets[m];if(y.cssRules)for(var g=0;g<y.cssRules.length;++g){var b=y.cssRules[g];if(-1!==b.cssText.indexOf(".lpk-live-photo-player")){f=b;break}}if(f){v=y;break}}catch(e){if("SecurityError"!==e.name)throw e}if(!v){var _=document.createElement("style");_.type="text/css",document.head.appendChild(_),v=_.sheet}var P="user-select: none;-khtml-user-select: none; -moz-user-select: none;-ms-user-select: none;-webkit-touch-callout: none; -webkit-user-select: none;";v.addRule?v.addRule(".lpk-live-photo-player",P):v.insertRule&&v.insertRule(".lpk-live-photo-player {"+P+"}",0)}}if(c&&document.querySelectorAll instanceof Function){var k=function(){w=!0,Array.prototype.forEach.call(document.querySelectorAll("[data-live-photo]"),function(e){return r.i(o.a)(e)})},x=function(){!w&&S&&T&&k()},S=/interactive|complete|loaded/.test(document.readyState),T=!!window.LivePhotosKit,w=!1;S||document.addEventListener("DOMContentLoaded",function(){S=!0,x()}),T||document.addEventListener("livephotoskitloaded",function(){T=!0,x()}),x()}},function(e,t,r){"use strict";function i(e){if(!e)return!1;try{e.appendChild(c),e.removeChild(c)}catch(e){return!1}return!0}var n=r(4),a=r(20),o=r(10),s=r(45),u=r(0),h=r(11),d=r(44),l=n.a.extend({staticMembers:{activeInstance:u.a.observableProperty(null)},renderer:u.a.observableProperty(function(){return a.a.create()}),showsNativeControls:u.a.observableProperty(!0),isPlaying:u.a.observableProperty(!1),wantsToPlay:u.a.observableProperty({defaultValue:!1,didChange:function(e){e&&(this.constructor.activeInstance=this)}}),canPlay:u.a.observableProperty({readOnly:!0,dependencies:["isPlaying","renderer.isFullyPreparedForPlayback"],get:function(){return this.isPlaying||this.renderer.isFullyPreparedForPlayback},didChange:function(e){e&&(this._hasHadCanPlay=!0,this.dispatchEvent(r.i(h.b)()),this.wantsToPlay&&this.play())}}),_generateErrorIfPlayedWithoutNecessaryMetadata:u.a.observer("renderer.cannotRenderDueToMissingPhotoTimeOrFrameTimes","wantsToPlay",function(e){e&&this.wantsToPlay&&(this.error=new Error("The `photoTime` and/or `frameTimes` values are missing. Provide them directly (or via `metadataVideoSrc`) if they cannot be parsed from the video.")),e||(this.error=null)}),errors:u.a.observableProperty({dependencies:["provider.error"],get:function(e){return e||this.provider.error||null}}),lastError:u.a.observableProperty({dependencies:["provider.lastError"],get:function(e){return e||this.provider.lastError||null},didChange:function(e){e&&(this.throwError(e),this.stop())}}),playbackRate:u.a.proxyProperty("renderer.videoDecoder.playbackRate"),currentTime:u.a.proxyProperty("renderer.currentTime"),renderedTime:u.a.proxyProperty("renderer.renderedTime"),duration:u.a.proxyProperty("renderer.duration"),videoWidth:u.a.proxyProperty("renderer.videoWidth"),videoHeight:u.a.proxyProperty("renderer.videoHeight"),photoWidth:u.a.proxyProperty("renderer.photoWidth"),photoHeight:u.a.proxyProperty("renderer.photoHeight"),recipe:u.a.proxyProperty("renderer.recipe"),playbackStyle:u.a.proxyProperty("renderer.playbackStyle"),provider:u.a.proxyProperty("renderer.provider"),proactivelyLoadsVideo:u.a.proxyProperty("provider.proactivelyLoadsVideo"),metadataVideoSrc:u.a.proxyProperty("provider.metadataVideoSrc"),photoMimeType:u.a.proxyProperty("provider.photoMimeType"),photoSrc:u.a.proxyProperty("provider.photoSrc"),photo:u.a.proxyProperty("provider.photo"),videoMimeType:u.a.proxyProperty("provider.videoMimeType"),videoSrc:u.a.proxyProperty("provider.videoSrc"),video:u.a.proxyProperty("provider.video"),photoTime:u.a.proxyProperty("provider.photoTime"),frameTimes:u.a.proxyProperty("provider.frameTimes"),videoRotation:u.a.proxyProperty("provider.videoRotation"),loadProgress:u.a.proxyProperty("provider.progress"),_isZeroSizeWarningLogged:u.a.observableProperty(!1),_renderWhenPossible:u.a.observer("renderer.video","renderer.photo",function(){if(this.error=null,this.updateSize(!0),!this._isZeroSizeWarningLogged){var e=this.element.getBoundingClientRect();0!==e.width&&0!==e.height||(console.warn("The LivePhotosKit Player located at position ("+e.left+", "+e.top+") in the viewport has either a zero width or zero height (or both) and will not render. To fix this, ensure that the Player has a style that will yield a non-zero width and height."),this._isZeroSizeWarningLogged=!0)}}),nativeControls:u.a.observableProperty({readOnly:!0,dependencies:["showsNativeControls"],get:function(){return this.showsNativeControls?this._nativeControls_cachedValue||(this._nativeControls_cachedValue=o.b.extend({owner:u.a.observableProperty(this),_slurpProgress:u.a.observer("owner.provider.progress",function(e){this.badgeView&&(this.badgeView.progress=e)}),_slurpError:u.a.observer("owner.errors",function(e){this.badgeView&&(this.badgeView.shouldShowError=!!e&&e.length>0)}),init:function(){var e=this;this._super.apply(this,arguments),this.badgeView.configurePlayAction(function(){return e.owner.play()}),this.badgeView.configureStopAction(function(){return e.owner.beginFinishingPlaybackEarly()})}}).create()):null},didChange:function(e){this._nativeControls_previousValue&&this._nativeControls_previousValue.detach(),this._nativeControls_previousValue=e,e&&e.attachInto(this)}}),init:function(e,t){var n=this;if(e&&!i(e))throw"Any pre-existing element provided for use as a LivePhotosKit.Player must be able to append child DOM nodes.";e&&e.childNodes.length&&(e.innerHTML="");for(var a in t)Object.prototype.hasOwnProperty.call(t,a)&&(this[a]=t[a]);switch(this._super(e),this.element.className="lpk-live-photo-player",r.i(d.a)(this.element,"position")||this.element.style.position){case"absolute":case"fixed":case"relative":break;default:this.element.style.position="relative"}switch(r.i(d.a)(this.element,"display")||this.element.style.display){case"block":case"inline-block":case"table":case"table-caption":case"table-column-group":case"table-header-group":case"table-footer-group":case"table-row-group":case"table-cell":case"table-column":case"table-row":break;default:this.element.style.display="inline-block"}this.renderer.attachInto(this),this.renderer.eventDispatchingElement=this.element,window.addEventListener("resize",this.updateSize),"ontouchstart"in document.documentElement&&(this.addEventListener("touchstart",function(){return n.play()},!1),this.addEventListener("touchend",function(){return n.beginFinishingPlaybackEarly()},!1))},play:function(){var e=this.provider;return e.video||(e.needsLoadedVideoForPlayback=!0),this.wantsToPlay=!0,this.canPlay&&(this.isPlaying=!0,this._lastFrameNow=Date.now(),this._nextFrame()),this.renderer.prepareToRenderAtTime(this.renderer.currentTime),this.isPlaying},pause:function(){this.isPlaying=!1,this.wantsToPlay=!1,this._cancelNextFrame()},stop:function(){this.pause(),this.currentTime=0,this.renderer.duration=NaN},toggle:function(){this.wantsToPlay?this.pause():this.play()},beginFinishingPlaybackEarly:function(){if(!this.isPlaying)return void(this.wantsToPlay=!1);var e=this.recipe;this.duration=Math.min(this.duration,Math.max(e.minimumShortenedDuration,this.currentTime+e.spontaneousFinishDuration))},_stopWhenAnotherPlayerStarts:u.a.observer("_constructor.activeInstance",function(e){e&&e!==this&&(this.stop(),this.renderer.reduceMemoryFootprint())}),_constructor:u.a.observableProperty(function(){return l}),_stopPlaybackWhenItemsLoadOrUnload:u.a.observer("video","photo",function(){this.isPlaying&&this.stop()}),addEventListener:function(e,t,r){var i=this.element;i.addEventListener.call(i,e,t,r)},removeEventListener:function(e,t,r){var i=this.element;i.removeEventListener.call(i,e,t,r)},_nextFrame:function(){var e=Date.now(),t=(e-this._lastFrameNow)*this.playbackRate;this._lastFrameNow=e,this.currentTime===this.renderedTime&&(this.currentTime+=t/1e3),this.currentTime<this.duration?this._rafID=requestAnimationFrame(this._nextFrame.bind(this)):(this.stop(),this.dispatchEvent(r.i(h.c)()))},_cancelNextFrame:function(){cancelAnimationFrame(this._rafID)},updateSize:u.a.boundFunction(function(e,t){if(this.photoWidth&&this.photoHeight){var i=!0===e?void 0:e,n=!0===e?e:void 0;if(isNaN(i)||isNaN(t)?(i=this.element.offsetWidth,t=this.element.offsetHeight):(i=Math.round(i),t=Math.round(t),this.element.style.width=i+"px",this.element.style.height=t+"px"),i&&t){if(!(this._lastUpdateChangeToken!==(this._lastUpdateChangeToken=i+":"+t))&&!n)return!1;var a=r.i(s.a)(this.photoWidth,this.photoHeight,i,t),o=Math.ceil(a.height),u=Math.ceil(a.width),h=Math.floor(i/2-u/2),d=Math.round(t/2-o/2),l=this.renderer;l.element.style.top=d+"px",l.element.style.left=h+"px",l.updateSize(u,o),this.displayWidth=i,this.displayHeight=t,this.nativeControls&&this.nativeControls.updateToRendererLayout(h,d,u,o)}}}),_dispatchPhotoLoadEventOnNewPhoto:u.a.observer("photo",function(e){e&&this.dispatchEvent(r.i(h.d)())}),_dispatchVideoLoadEventOnNewVideo:u.a.observer("video",function(e){e&&this.dispatchEvent(r.i(h.e)())}),throwError:function(e){this.dispatchEvent(r.i(h.f)({error:e,errorCode:e.errCode}))}}),c=document.createElement("div");t.a=l},function(e,t,r){"use strict";function i(){f=!1}function n(){}function a(e,t){return-(e.importance-t.importance)||e.number-t.number}function o(e,t){for(var r=0,i=e.length,n=0;n<i-r;n++)if(e[n]===t&&(r++,n--),r){var a=n+1;e[a]=e[a+r]}return e.length-=r,e}var s=r(43),u=r(24),h=r(0),d=r(15),l=r(1),c=-1!==location.href.indexOf("_lpk_play_to_decode=true")||-1===location.href.indexOf("_lpk_play_to_decode=false")&&(!l.a.isSafari&&!l.a.isIOS),p=-1!==location.href.indexOf("_lpk_persistent_frames=true")||(location.href.indexOf("_lpk_persistent_frames=false"),!1),f=!0,v=h.a.Object.extend({id:h.a.property(function(){return r.i(s.a)()}),provider:h.a.observableProperty(),video:h.a.proxyProperty("provider.video"),duration:h.a.proxyProperty("provider.videoDuration"),videoRotation:h.a.proxyProperty("provider.videoRotation"),frameTimes:h.a.proxyProperty("provider.frameTimes"),get frameCount(){var e=this.frameTimes;return e?e.length:0},canProvideFrames:h.a.observableProperty({readOnly:!0,dependencies:["video"],get:function(){return!!this.video}}),videoWidth:h.a.observableProperty({readOnly:!0,dependencies:["video","videoRotation"],get:function(){var e=this.video;if(e)return this.videoRotation%180==0?e.videoWidth:e.videoHeight}}),videoHeight:h.a.observableProperty({readOnly:!0,dependencies:["video","videoRotation"],get:function(){var e=this.video;if(e)return this.videoRotation%180==0?e.videoHeight:e.videoWidth}}),playbackRate:h.a.observableProperty(1),_sendPlaybackRateToVideo:h.a.observer("playbackRate","video",function(e,t){t&&(t.playbackRate=e)}),_pendingFrames:h.a.property(function(){return[]}),init:function(){this._largeCanvas=document.createElement("canvas"),this._largeContext=this._largeCanvas.getContext("2d"),this._super.apply(this,arguments)},_handleVideoChange:h.a.observer("video",function(){var e=this.video,t=this._lastVideo;if(this._lastVideo=e,e!==t&&(t&&this.cleanUpOldVideo(t),e&&this.setUpNewVideo(e),e&&p))for(var r=d.a?1:0;this.frameTimes&&r<this.frameTimes.length;r++)this.getFrame(r).retain()}),setUpNewVideo:function(e){e.addEventListener("seeked",this._seeked),e.muted=!0},cleanUpOldVideo:function(e){e.removeEventListener("seeked",this._seeked),e.playbackRate=1,e.muted=!1,e.pause(),this._stopSeekingEntirely()},fractionalIndexForTime:function(e){if(e=Math.min(this.duration,Math.max(0,e)),isNaN(e))return e;var t=this.frameTimes,r=t.length,i=void 0;for(i=0;i<r&&t[i]<e;i++);i&&i--;var n=t[i],a=t[i+1];return a?i+Math.min(1,(e-n)/(a-n)):i},timeForFractionalIndex:function(e){if(e<=0)return 0;if(e>=this.frameTimes.length)return this.duration;var t=0|e,r=Math.ceil(e);if(t===r)return this.frameTimes[t];var i=this.frameTimes[t],n=r<this.frameTimes.length?this.frameTimes[r]:this.duration;return n?i+(e-t)*(n-i):i},getFrame:function(e,t){if(!this.frameTimes)throw"Attempted to get frame before ready.";if(isNaN(this.frameTimes[e]))throw"Frame number "+e+" is is not a frame in the video.";var r=u.a.getCached(this,e);return isNaN(t)||(r.importance=Math.max(r.importance,t)),r.readyState||(this._pendingFrames.push(r),this._pendingFrames.sort(a),r.didPend(),this._isSeeking||this._scheduleArtificialSeek()),r},peekFrame:function(e){var t=u.a.peekCached(this,e);return t&&2===t.readyState&&!t.lacksOwnPixelData?t:null},getNearestDecodedFrame:function(e){for(var t=Math.max(e,this.frameTimes.length-1-e),r=-1;++r<=t;){var i=this.peekFrame(e+r)||this.peekFrame(e-r);if(i)return i}return null},_scheduleArtificialSeek:function(){this._artificialSeekTimeout||(this._artificialSeekTimeout=setTimeout(this._seeked),this._artificialSeekRAFId=requestAnimationFrame(this._seeked))},_unscheduleArtificialSeek:function(){this._artificialSeekTimeout&&(clearTimeout(this._artificialSeekTimeout),this._artificialSeekTimeout=null,cancelAnimationFrame(this._artificialSeekRAFId),this._artificialSeekRAFId=null)},_stopSeekingEntirely:function(){this._unscheduleArtificialSeek(),this._isPlaying=!1,this._isSeeking=!1,this._expectedNextSeenFrameNumber=NaN,this.video&&this.video.pause()},_seeked:h.a.boundFunction(function(e){if(!(e instanceof Event&&e.target!==this.video)&&(e instanceof Event||this.video)){this._unscheduleArtificialSeek(),this._isSeeking=!1;var t=this.fractionalIndexForTime(this.video.currentTime);t|=0;for(var r,a=this._pendingFrames,o=NaN,s=0;r=a[s];s++)if(r.number===t){o=t,r.didDecode(),this._removePendingFrame(r);break}var u=this._expectedNextSeenFrameNumber;if(this._expectedNextSeenFrameNumber=NaN,u<o)for(var h,d=0;h=a[d];d++)h.number>=u&&h.number<o&&(h.didGetSkipped(),this._removePendingFrame(h),d--);var l=a[0];if(!l)return this._isPlaying&&(this._isPlaying=!1,this.video.pause()),void(this._expectedNextSeenFrameNumber=NaN);var p=l.number>t&&l.number<=t+2&&f;if(c||(p=!1),p){if(!this._isPlaying){this._isPlaying=!0;try{var v=this.video.play();v&&v.then instanceof Function&&v.then(n,i)}catch(e){f=!1}}this._expectedNextSeenFrameNumber=l.number,this._scheduleArtificialSeek()}else this._isPlaying&&(this._isPlaying=!1,this.video.pause()),this._expectedNextSeenFrameNumber=NaN,this.video.currentTime=l.time+1e-4,this._isSeeking=!0}}),_frameWillDispose:function(e){this._removePendingFrame(e)},_removePendingFrame:function(e){o(this._pendingFrames,e),this._pendingFrames.length||this._unscheduleArtificialSeek()}});t.a=v},function(e,t,r){"use strict";function i(e){e.container=document.createElement("div"),e.container.frame=e,e.container.innerHTML='<div style="position:absolute; left:0; right:0; top:0; bottom:0; text-align:center; line-height:30px; color:white; text-shadow: black 0px 0px 4px,black 0px 0px 4px,black 0px 0px 4px,black 0px 0px 4px; font-family:HelveticaNeue-Light;"></div>',e.textBox=e.container.lastChild,e.container.insertBefore(e.image,e.textBox),e.image.style.position="absolute",e.container.style.cssText="position:relative; display:inline-block; border: 1px solid black;";var t=e._debug_aspect||(e._debug_aspect=e.videoDecoder&&(e.videoDecoder.videoWidth>e.videoDecoder.videoHeight?"landscape":"portrait"));e.container.style.width=e.image.style.width="landscape"===t?"40px":"30px",e.container.style.height=e.image.style.height="landscape"===t?"30px":"40px",document.body.appendChild(e.container)}var n=r(12),a=r(40),o=r(2),s=r(0),u=r(38),h=r(1);r.d(t,"a",function(){return d});var d=s.a.Object.extend(u.a,a.a,{staticMembers:{getPoolingCacheKey:function(e,t){return"f"+t+"_in_"+e.id}},container:null,image:null,_context:null,number:-1,time:-1,importance:0,videoDecoder:null,readyState:0,_poolingCacheKey:null,_debugShowInDOM:n.a,lacksOwnPixelData:!1,_postDispose:function(){this.image.width=this.image.height=0},get backingFrame(){return this.lacksOwnPixelData?this.videoDecoder.getNearestDecodedFrame(this.number)||this:this},init:function(){this._postDispose=this._postDispose.bind(this);var e=this.image=document.createElement("canvas");this._context=this.image.getContext("2d"),this._super(),this._debugShowInDOM?i(this):c&&(c.appendChild(e),e.style.cssText="position: absolute; top: 0px; width:1px; height: 1px; display: inline-block;",e.style.left=l+++"px")},initFromPool:function(e,t){clearTimeout(this._postDisposalTimeout),this.videoDecoder=e,this.number=t,this.time=e.frameTimes[t],this._debugShowInDOM&&(this.textBox.innerHTML=this.number)},dispose:function(){this.resetReadiness(),this.videoDecoder._frameWillDispose(this),this.number=this.time=-1,this.importance=0,this.videoDecoder=null,this.readyState=0,this.lacksOwnPixelData=!1,this._postDisposalTimeout=setTimeout(this._postDispose,3e3),this.constructor._disposeInstance(this),this._debugShowInDOM&&(this.textBox.innerHTML="x",this.textBox.style.color="#FF0000",this._context.clearRect(0,0,this.image.width,this.image.height))},didPend:function(){this.readyState=1,this._debugShowInDOM&&(this.textBox.style.color="#FF8800")},didDecode:function(){this.obtainPixelData(),this.readyState=2,this.resolveReadiness(this),this._debugShowInDOM&&(this.textBox.style.color="#00FF00")},obtainPixelData:function(){var e=this.image,t=this._context,r=this.videoDecoder,i=r.videoRotation,n=r.videoWidth,a=r.videoHeight,o=i%180==0?n:a,s=i%180==0?a:n;e.width===n&&e.height===a||(e.width=n,e.height=a),h.a.isFirefox&&t.getImageData(0,0,1,1);for(var u=0;u<i;u+=90)t.translate(u%180?a:n,0),t.rotate(Math.PI/2);t.drawImage(r.video,0,0,o,s),t.setTransform(1,0,0,1,0,0)},didGetSkipped:function(){o.a.log("    Skipped decoding frame "+this.number+". Using nearest frame instead."),this.lacksOwnPixelData=!0,this.readyState=2,this.resolveReadiness(this),this._debugShowInDOM&&(this._context.fillStyle="red",this._context.fillRect(0,0,this.image.width,this.image.height),this.textBox.style.color="#00FF00")}}),l=0,c=function(){if(!h.a.isIE&&!h.a.isEdge)return null;var e=document.createElement("div");return e.style.cssText="top: 0px; left: 0px; width: 50px; height: 1px; overflow: hidden; position: absolute; z-index: 100000; opacity: 0.001; pointer-events: none;",document.body?document.body.appendChild(e):setTimeout(function(){return document.body.appendChild(e)},0),e}()},function(e,t,r){"use strict";var i=r(0),n=i.a.Object.extend({state:i.a.observableProperty("unloaded"),validateResult:function(e){return!!e},loadSrc:function(e){},abortCurrentLoad:function(){},isSrcLoadAllowed:i.a.observableProperty(!0),_loadSrcOnceAllowed:i.a.observer("isSrcLoadAllowed",function(e){if(e){if("unloaded"===this.state){var t=this.src;t&&(this.state="loading",this.loadSrc(t))}}}),src:i.a.observableProperty({didChange:function(e){this._isWritingSrcDueToWritingOfResult||(this._isWritingResultDueToWritingOfSrc=!0,this.result=null,this._isWritingResultDueToWritingOfSrc=!1,this.abortCurrentLoad(),e&&this.isSrcLoadAllowed?(this.state="loading",this.loadSrc(e)):this.state="unloaded")}}),result:i.a.observableProperty({decideRequiresUpdate:function(){return!0},didChange:function(e){if(!this._isWritingResultDueToWritingOfSrc){var t=this.validateResult(e)?"loaded":e||this._isWritingResultDueToError?"errored":"unloaded";this._isWritingResultDueToLoadOfSrc||this._isWritingResultDueToError||(this._isWritingSrcDueToWritingOfResult=!0,this.src=null,this._isWritingSrcDueToWritingOfResult=!1,this.abortCurrentLoad(),this.state="unloaded"),this.state=t}}}),error:i.a.observableProperty(null),_clearErrorOnceNoLongerErrored:i.a.observer("state",function(e){"errored"!==e&&(this.error=null)}),progress:i.a.observableProperty({defaultValue:0,dependencies:["state"],get:function(e){return"loading"===this.state?Math.min(1,Math.max(0,+e||0)):"loaded"===this.state?1:0}}),_clearProgressOnceUnloaded:i.a.observer("state",function(e){"unloaded"===e&&(this.progress=0)}),loadDidFail:function(e){"loading"===this.state&&(this._isWritingResultDueToError=!0,this.result=null,this._isWritingResultDueToError=!1,this.error=e)},loadDidSucceed:function(e){"loading"===this.state&&(this._isWritingResultDueToLoadOfSrc=!0,this.result=e,this._isWritingResultDueToLoadOfSrc=!1,this.error=null)}});t.a=n},function(e,t,r){"use strict";function i(e,t,r){var i=e.getContext("2d"),n=7===r||8===r?270:3===r||4===r?180:5===r||6===r?90:0,a=t.naturalWidth,o=t.naturalHeight,s=n%180==0?a:o,u=n%180==0?o:a,h=2===r||4===r?-1:1,d=5===r||7===r?-1:1;e.width===s&&e.height===u||(e.width=s,e.height=u);for(var l=0;l<n;l+=90)i.translate(l%180?u:s,0),i.rotate(Math.PI/2);i.scale(h,d),i.translate((h-1)/2*a,(d-1)/2*o),i.drawImage(t,0,0),i.setTransform(1,0,0,1,0,0)}var n=r(13),a=r(46),o=r(3),s=[],u={},h=n.a.extend({mimeType:"image/jpeg",beginSecondaryLoad:function(e,t){this._exifOrientationInLastLoadedBuffer=r.i(a.a)(e),s[0]=e,u.type=t,this._internalImage.src=this._internalImageSrc=URL.createObjectURL(new Blob(s,u)),(window.photoBuffers||(window.photoBuffers=[])).push(e)},abortCurrentSecondaryLoad:function(){this.__internalImage&&this._internalImage.removeAttribute("src"),this._internalImageSrc&&(URL.revokeObjectURL(this._internalImageSrc),this._internalImageSrc=null),this._exifOrientationInLastLoadedBuffer=null},get _internalImage(){var e=this.__internalImage;return e||(e=this.__internalImage=new Image,e.addEventListener("load",this._internalImageLoadDidSucceed.bind(this)),e.addEventListener("error",function(e){this.loadDidFail(e)}.bind(this))),e},get _internalCanvas(){return this.__internalCanvas||(this.__internalCanvas=document.createElement("canvas"))},loadDidFail:function(e){if(e)return e.errCode=o.a.PHOTO_FAILED_TO_LOAD,this._super(e)},_internalImageLoadDidSucceed:function(){var e=this._internalImage;1!==this._exifOrientationInLastLoadedBuffer&&(i(this._internalCanvas,this._internalImage,this._exifOrientationInLastLoadedBuffer),e=this._internalCanvas),this.loadDidSucceed(e)}});t.a=h},function(e,t,r){"use strict";var i=r(0),n=r(28),a=r(26),o=i.a.Object.extend({videoSrc:i.a.proxyProperty("_videoProvider.src"),videoMimeType:i.a.proxyProperty("_videoProvider.mimeType"),video:i.a.proxyProperty("_videoProvider.result"),photoSrc:i.a.proxyProperty("_photoProvider.src"),photoMimeType:i.a.proxyProperty("_photoProvider.mimeType"),photo:i.a.proxyProperty("_photoProvider.result"),metadataVideoSrc:i.a.proxyProperty("_metadataVideoProvider.src"),progress:i.a.observableProperty({readOnly:!0,dependencies:["_photoProvider.progress","_videoProvider.state","_videoProvider.progress","_metadataVideoProvider.state","_metadataVideoProvider.progress"],get:function(){var e=this._videoProvider,t=this._metadataVideoProvider,r=e.state,i=t.state,n="unloaded"!==r||"unloaded"!==i?.75:0,a=n?"unloaded"===i?e.progress:(e.progress+t.progress)/2:0;return this._photoProvider.progress*(1-n)+a*n}}),photoTime:i.a.observableProperty({dependencies:["_metadataVideoProvider.photoTime","_videoProvider.photoTime"],get:function(e){return+e===e?e:this._metadataVideoProvider.photoTime||this._videoProvider.photoTime||null}}),videoRotation:i.a.observableProperty({dependencies:["_videoProvider.videoRotation"],get:function(e){if(+e===e)return e;var t=this._videoProvider.videoRotation;return+t===t?t:null},set:function(e){return 90*Math.round(e/90)%360|0}}),frameTimes:i.a.observableProperty({dependencies:["_metadataVideoProvider.frameTimes","_videoProvider.frameTimes"],get:function(e){return e||(this._metadataVideoProvider.frameTimes||this._videoProvider.frameTimes)},set:function(e){if(!e)return null;if("string"==typeof e){var t=i.a.arrayPool.get();i.a.String.splitIntoArray(e,",",t),i.a.Array.mapIntoArray(t,function(e){return Number(e.trim())},t),e=t}for(var r=Array.isArray(e),n=r&&e.length>=2,a=0,o=e.length;a<o&&n;a++){var s=e[a];+s!==s&&(n=!1)}if(!n)throw new Error("If frameTimes is provided, it must be provided as an Array or comma-delimited string of at least two numbers.");return e}}),videoDuration:i.a.observableProperty({readOnly:!0,dependencies:["frameTimes"],get:function(){return this.frameTimes?this.frameTimes[this.frameTimes.length-1]:void 0}}),proactivelyLoadsVideo:i.a.observableProperty(!1),needsLoadedVideoForPlayback:i.a.observableProperty(!1),_reset_needsLoadedVideoForPlayback_whenAppropriate:i.a.observer("video",function(){this.needsLoadedVideoForPlayback=!1}),isVideoLoadAllowed:i.a.observableProperty({readOnly:!0,dependencies:["proactivelyLoadsVideo","needsLoadedVideoForPlayback"],get:function(){return this.proactivelyLoadsVideo||this.needsLoadedVideoForPlayback}}),error:i.a.observableProperty({readOnly:!0,dependencies:["_videoProvider.error","_photoProvider.error"],get:function(){return[this._photoProvider.error,this._videoProvider.error].filter(function(e){return!!e})}}),lastError:i.a.observableProperty(),_lastPhotoError:i.a.observableProperty({readOnly:!0,dependencies:["_photoProvider.error"],get:function(){return this._photoProvider.error},didChange:function(e){this.lastError=e}}),_lastVideoError:i.a.observableProperty({readOnly:!0,dependencies:["_videoProvider.error"],get:function(){return this._videoProvider.error},didChange:function(e){this.lastError=e}}),_metadataVideoProvider:i.a.observableProperty(function(){return n.a.extend({requiresMimeTypeForRawArrayBufferSrc:!1,actuallyProvidesResultingVideoFromSecondaryLoad:!1}).create()}),_videoProvider:i.a.observableProperty(function(){return n.a.extend({owner:i.a.observableProperty(this),isSrcLoadAllowed:i.a.proxyProperty("owner.isVideoLoadAllowed"),exposedSrcKeyForErrorStrings:"videoSrc",exposedMimeTypeKeyForErrorStrings:"videoMimeType"}).create()}),_photoProvider:i.a.observableProperty(function(){return a.a.extend({exposedSrcKeyForErrorStrings:"photoSrc",exposedMimeTypeKeyForErrorStrings:"photoMimeType"}).create()})});t.a=o},function(e,t,r){"use strict";function i(e,t){if(e===t)return!0;if(!e||!t)return!1;var r=e.length;if(r!==t.length)return!1;for(var i=0;i<r;i++)if(e[i]!==t[i])return!1;return!0}var n=r(13),a=r(37),o=r(0),s=r(2),u=r(3),h=r(1),d=[],l={},c=n.a.extend({__internalVideo:null,_internalVideoSRC:null,photoTime:o.a.observableProperty(),frameTimes:o.a.observableProperty(),videoRotation:o.a.observableProperty(),actuallyProvidesResultingVideoFromSecondaryLoad:!0,_clearMetadataPropertiesOnUnload:o.a.observer("state",function(e){"loaded"!==e&&(this.photoTime=this.frameTimes=this.videoRotation=void 0)}),beginSecondaryLoad:function(e,t){this.preprocessAndAttemptToReadMetadataFromBuffer(e),this.actuallyProvidesResultingVideoFromSecondaryLoad&&(d[0]=e,l.type="video/quicktime"===t?"video/mp4":t,"application/octet-stream"===t&&s.a.warn('Encountered a Content-Type of "application/octet-stream" for the file obtained for `videoSrc`.Some browsers may be unable to use the video with this MIME type. If the video portion of the Player is not functioning, make sure the proper MIME type is being provided with the response.'),this._internalVideo.src=this._internalVideoSRC=URL.createObjectURL(new Blob(d,l)),h.a.isIOS&&this._internalVideo.load())},abortCurrentSecondaryLoad:function(){this.__internalVideo&&(this.__internalVideo.pause(),this.__internalVideo.removeAttribute("src"),this.__internalVideo.load(),h.a.isIOS&&(this.__internalVideo=null),this._internalVideoSRC&&(URL.revokeObjectURL(this._internalVideoSRC),this._internalVideoSRC=null))},get _internalVideo(){var e=this.__internalVideo;return e||(e=this.__internalVideo=document.createElement("video"),e.addEventListener("canplay",this.loadDidSucceed.bind(this)),e.addEventListener("error",this.loadDidFail.bind(this)),e.volume=0),e},loadDidFail:function(e){if(e)return e.errCode=u.a.VIDEO_FAILED_TO_LOAD,this._super(e);var t=this.__internalVideo;return t.error.errCode=u.a.VIDEO_FAILED_TO_LOAD,t?this._super(t.error):t},loadDidSucceed:function(){var e=this.__internalVideo;return e?this._super(e):e},preprocessAndAttemptToReadMetadataFromBuffer:function(e){var t=void 0,r=void 0;try{t=new a.a(new a.b(e)),t.read()}catch(e){t=null}if(!t)return this.photoTime=null,this.frameTimes=null,void(this.videoRotation=0);var n=(r=t.tracks)&&(r=r.vide)&&(r=r[0])&&r.getAllSampleSeconds&&r.getAllSampleSeconds();n&&(this.frameTimes=n);var o=void 0;try{o=t.tracks.meta[0].timeToSeconds(t.tracks.meta[0].trak.edts.elst.editList[0].trackDuration)}catch(e){}o&&(this.photoTime=o);var s=new Uint8Array(e),u=(r=t.tracks)&&(r=r.soun)&&(r=r[0])&&(r=r.trak)&&r.offset;if(u){var h="free";s[u+4]=h.charCodeAt(0),s[u+5]=h.charCodeAt(1),s[u+6]=h.charCodeAt(2),s[u+7]=h.charCodeAt(3)}var d=[],l=p[0],c=(r=t.tracks)&&(r=r.vide)&&(r=r[0])&&(r=r.trak)&&(r=r.tkhd)&&(r=r.offset)&&r+48,f=0;if(c){for(var v=0;v<l.length;v++)d[v]=s[c+v];for(var m=0;m<p.length;m++)if(i(p[m],d)){f=90*m;break}if(f)for(var y=0;y<l.length;y++)s[c+y]=l[y]}this.videoRotation=f}}),p=["  0   1 0 0  |    0   0 0 0   |   0 0 0 0   |    0   0 0 0   |    0   1 0 0   |   0 0 0 0   |   0   0 0 0   |   0   0 0 0   |   64 0 0 0","  0   0 0 0  |    0   1 0 0   |   0 0 0 0   |  255 255 0 0   |    0   0 0 0   |   0 0 0 0   |   4  56 0 0   |   0   0 0 0   |   64 0 0 0","255 255 0 0  |    0   0 0 0   |   0 0 0 0   |    0   0 0 0   |  255 255 0 0   |   0 0 0 0   |   5 160 0 0   |   4  56 0 0   |   64 0 0 0","  0   0 0 0  |  255 255 0 0   |   0 0 0 0   |    0   1 0 0   |    0   0 0 0   |   0 0 0 0   |   0   0 0 0   |   5 160 0 0   |   64 0 0 0"].map(function(e){return e.replace(/\|/g,"").trim().split(/\s+/g).map(parseFloat)});t.a=c},function(e,t,r){"use strict";var i=r(7),n=r(5),a=r(1),o=a.a.isSafari,s=i.a.create({correspondingPlaybackStyle:n.a.FULL,get minimumShortenedDuration(){return this.enterDuration+this.exitDuration+.01},get spontaneousFinishDuration(){return this.exitDuration},enterDuration:1/3,exitDuration:.5,videoBeginTime:.15,zoomScaleFactor:1.075,blurRadius:5,blurRadiusStep:.2,quantizeRadius:function(e){return this.blurRadiusStep?Math.round(e/this.blurRadiusStep)*this.blurRadiusStep:e},easeInOut:function(e){return e<0?0:e>1?1:.5-.5*Math.cos(e*Math.PI)},calculateAnimationDuration:function(e,t){return e?e+this.videoBeginTime+this.exitDuration:0},getEntranceExitParameter:function(e,t){return Math.min(Math.max(0,Math.min(1,1-this.easeInOut((e-(t-this.exitDuration))/this.exitDuration))),1-Math.max(0,Math.min(1,1-this.easeInOut(e/this.enterDuration))))||0},getTransform:function(e,t,r,i){var n=arguments.length>4&&void 0!==arguments[4]?arguments[4]:1,a=arguments.length>5&&void 0!==arguments[5]?arguments[5]:1,o=arguments.length>6&&void 0!==arguments[6]?arguments[6]:1,s=1+(this.zoomScaleFactor-1)*this.getEntranceExitParameter(e,t),u=-(s-1)/2*r,h=-(s-1)/2*i,d=Math.round(u*devicePixelRatio)/devicePixelRatio,l=Math.round(h*devicePixelRatio)/devicePixelRatio;return Math.abs(s-n)<1e-5?"translate3d("+d+"px, "+l+"px, 0) scale3d("+a+", "+o+", 1)":u||h||s?"translate3d("+u+"px, "+h+"px, 0) scale3d("+s+", "+s+", 1)":"translate3d(0, 0, 0)"},photo:i.a.PhotoIngredient.create({opacity:i.a.computedStyle(function(e){if(e<this.recipe.enterDuration)return(1-this.recipe.easeInOut(e/this.recipe.enterDuration)).toString();if(e<this.renderer.duration-this.recipe.exitDuration)return"0";var t=this.recipe.easeInOut((e-(this.renderer.duration-this.recipe.exitDuration))/this.recipe.exitDuration);return 1!==t?t:"1"}),display:i.a.computedStyle(function(e){return e>this.recipe.enterDuration&&e<this.renderer.duration-this.recipe.exitDuration?"none":""}),filter:i.a.computedStyle(function(e){if(!o)return"";var t=this.recipe,r=t.blurRadius*t.getEntranceExitParameter(e,this.renderer.duration);return r?"blur("+t.quantizeRadius(r)+"px)":""}),transform:i.a.computedStyle(function(e){return this.recipe.getTransform(e,this.renderer.duration,this.displayWidth,this.displayHeight)}),zIndex:i.a.computedStyle(function(){return 3})}),video:i.a.VideoIngredient.create({get backingScaleFactor(){return this.recipe.zoomScaleFactor},lookaheadTime:.01+7/15,videoTimeAtTime:function(e){var t=Math.max(0,Math.min(this.videoDuration,e-this.recipe.videoBeginTime));return Math.min(t,this.renderer.duration-this.recipe.exitDuration-this.recipe.videoBeginTime)},prepareVideoFramesFromTime:function(e){this.retainFramesForTime(e,e+this.lookaheadTime)},display:i.a.computedStyle(function(e){return 0===e||e===this.renderer.duration?"none":""}),transform:i.a.computedStyle(function(e){return this.recipe.getTransform(e,this.renderer.duration,this.displayWidth,this.displayHeight,this.backingScaleFactor,this.backingScaleX,this.backingScaleY)}),zIndex:i.a.computedStyle(function(){return 1})})});t.a=s},function(e,t,r){"use strict";var i=r(7),n=r(5),a=i.a.create({correspondingPlaybackStyle:n.a.HINT,minimumShortenedDuration:.9,get spontaneousFinishDuration(){return this.exitBlurDuration},exitBlurDuration:.75,bottomVideoRevealBeginTime:.1,zoomScaleFactor:1.075,blurRadius:7.5,blurRadiusStep:1,quantizeRadius:function(e){return Math.round(e/this.blurRadiusStep)*this.blurRadiusStep},tween:function(e){return e<0?0:e>1?1:.5-.5*Math.cos(e*Math.PI)},calculateAnimationDuration:function(e,t){return e?e-t+this.exitBlurDuration:0},photo:i.a.PhotoIngredient.create({hideDuration:.06,get returnDuration(){return this.recipe.exitBlurDuration},opacity:i.a.computedStyle(function(e){if(e<this.hideDuration)return(1-this.recipe.tween(e/this.hideDuration)).toString();if(e<this.renderer.duration-this.returnDuration)return"0";var t=this.recipe.tween((e-(this.renderer.duration-this.returnDuration))/this.returnDuration);return 1!==t?t.toString():""}),display:i.a.computedStyle(function(e){return e>this.hideDuration&&e<this.renderer.duration-this.returnDuration?"none":""}),webkitFilter:i.a.computedStyle(function(e){if(e<this.renderer.duration-this.returnDuration)return"";var t=this.recipe.blurRadius*(1-this.recipe.tween((e-(this.renderer.duration-this.returnDuration))/this.returnDuration));return t?"blur("+this.recipe.quantizeRadius(t)+"px)":""}),transform:i.a.computedStyle(function(e){if(e<this.renderer.duration-this.returnDuration)return"translateZ(0)";var t=1+(this.recipe.zoomScaleFactor-1)*(1-this.recipe.tween((e-(this.renderer.duration-this.returnDuration))/this.returnDuration));return"translate3d("+-(t-1)/2*this.displayWidth+"px, "+-(t-1)/2*this.displayHeight+"px, 0) scale3d("+t+", "+t+", 1)"}),zIndex:i.a.computedStyle(function(){return 3})}),video:i.a.VideoIngredient.create({get backingScaleFactor(){return this.recipe.zoomScaleFactor},scaleInDuration:.15,get blurOutDuration(){return this.recipe.exitBlurDuration},lookaheadTime:.01+7/15,videoTimeAtTime:function(e){return Math.min(this.videoDuration,e+this.renderer.photoTime)},prepareVideoFramesFromTime:function(e){this.retainFramesForTime(e,e+this.lookaheadTime)},display:i.a.computedStyle(function(e){return e&&e!==this.renderer.duration?"":"none"}),transform:i.a.computedStyle(function(e){var t=1+(this.recipe.zoomScaleFactor-1)*Math.max(0,Math.min(1,1-this.recipe.tween((e-(this.renderer.duration-this.blurOutDuration))/this.blurOutDuration)-(1-this.recipe.tween(e/this.scaleInDuration)))),r=-(t-1)/2*this.displayWidth,i=-(t-1)/2*this.displayHeight,n=Math.round(r*devicePixelRatio)/devicePixelRatio,a=Math.round(i*devicePixelRatio)/devicePixelRatio;return Math.abs(t-this.backingScaleFactor)<1e-5?"translate3d("+n+"px, "+a+"px, 0) scale3d("+this.backingScaleX+", "+this.backingScaleY+", 1)":"translate3d("+r+"px, "+i+"px, 0) scale3d("+t+", "+t+", 1)"}),webkitFilter:i.a.computedStyle(function(e){var t=this.recipe.blurRadius*this.recipe.tween((e-(this.renderer.duration-this.blurOutDuration))/this.blurOutDuration);return t?"blur("+this.recipe.quantizeRadius(t)+"px)":""}),zIndex:i.a.computedStyle(function(){return 1})})});t.a=a},function(e,t,r){"use strict";var i=r(33),n=r(14),a=r(41),o=i.a.extend(n.a,{tagName:"canvas",get _canvas(){return this.element},get _context(){return this.__context||(this.__context=this._canvas.getContext("2d"))},init:function(){this._super.apply(this,arguments),this.element.className="lpk-render-layer lpk-photo",this.element.style.position="absolute",this.element.style.width=this.element.style.height="100%",this.element.style.transformOrigin="0 0"},updateSize:function(e,t){if(!arguments.length)return this._super();this._super(e,t);var i=Math.ceil(e*devicePixelRatio),n=Math.ceil(t*devicePixelRatio),o=this.photo,s=this._canvas;this._lastPhoto===(this._lastPhoto=o)&&s.width===i&&s.height===n||(s.width=i,s.height=n,o&&r.i(a.a)(this._context,o,0,0,i,n))},tearDownFromRender:function(){this._super(),this._canvas.width=this._canvas.height=0}});t.a=o},function(e,t,r){"use strict";var i=r(34),n=r(14),a=r(0),o=i.a.extend(n.a,{_loCanvas:null,_hiCanvas:null,backingScaleFactor:1,setUpForRender:function(){var e=this.element;if(!this._loCanvas||!this._hiCanvas){e.innerHTML&&(e.innerHTML="");var t=this._loCanvas=a.a.canvasPool.get(),r=this._hiCanvas=a.a.canvasPool.get();t._context=t.getContext("2d"),r._context=r.getContext("2d"),t.style.cssText=r.style.cssText="position: absolute; left: 0; top: 0; width: 100%; height: 100%; transform: translateZ(0);",e.appendChild(t),e.appendChild(r),this._swapCanvases()}e.className="lpk-render-layer lpk-video",e.style.position="absolute",e.style.transformOrigin="0 0",this._super.apply(this,arguments)},updateSize:function(e,t){if(!arguments.length)return this._super();this._super(e,t);var r=Math.ceil(e*this.backingScaleFactor),i=Math.ceil(t*this.backingScaleFactor);this.backingScaleX=r/e,this.backingScaleY=i/t,this.element.style.width=r+"px",this.element.style.height=i+"px",this._loCanvas&&this._hiCanvas&&(this._loCanvas.width=this._hiCanvas.width=r*devicePixelRatio,this._loCanvas.height=this._hiCanvas.height=i*devicePixelRatio,this._loCanvas._drawnFrameNumber=this._hiCanvas._drawnFrameNumber=-1,this.renderAtTime())},renderAtTime:function(e){if(!arguments.length)return this._super();this._super(e);var t=this.backingScaleX,r=this.backingScaleY;1===t&&1===r||(this.element.style.transform+=" scale3d("+1/t+", "+1/r+", 1)")},renderFramePair:function(e,t,r){(e&&this._hiCanvas._drawnFrameNumber===e.number||t&&this._loCanvas._drawnFrameNumber===t.number)&&this._swapCanvases(),this._putFrameInCanvasIfNeeded(e,this._loCanvas),this._putFrameInCanvasIfNeeded(t,this._hiCanvas),t&&(this._hiCanvas.style.opacity=r)},_swapCanvases:function(){var e=this._hiCanvas;this._hiCanvas=this._loCanvas,this._loCanvas=e,this._loCanvas.style.opacity="",this._loCanvas.style.zIndex=1,this._hiCanvas.style.zIndex=2},_putFrameInCanvasIfNeeded:function(e,t){t._drawnFrameNumber!==(t._drawnFrameNumber=e?e.number:-1)&&(t.setAttribute("data-frame-number",t._drawnFrameNumber.toString()),e?t._context.drawImage(e.image,0,0,t.width,t.height):t._context.clearRect(0,0,t.width,t.height))},dispose:function(){this._super(),this._loCanvas&&a.a.canvasPool.ret(this._loCanvas),this._hiCanvas&&a.a.canvasPool.ret(this._hiCanvas)}});t.a=o},function(e,t,r){"use strict";var i=r(8),n=r(0),a=i.a.extend({photo:n.a.proxyProperty({readOnly:!0,proxyPath:"renderer.photo"}),canRender:n.a.proxyProperty("photo"),display:function(){return""},canRenderAtTime:function(e){var t=this.photo;return!("none"!==this.display(e)&&(!t||t instanceof Image&&!t.complete))}});t.a=a},function(e,t,r){"use strict";function i(e){e.retain()}function n(e){e.release()}var a=r(8),o=r(0),s=r(15),u=a.a.extend({videoDecoder:o.a.proxyProperty("renderer.videoDecoder"),videoDuration:o.a.proxyProperty("videoDecoder.duration"),display:function(){return""},canRender:o.a.proxyProperty({readOnly:!0,proxyPath:"videoDecoder.canProvideFrames"}),init:function(){this._super.apply(this,arguments);var e=this.recipe.name+"_"+this.layerName;this._framePrepIDKey=e+"_framePrepID"},videoTimeAtTime:function(e){return e},_videoTimeAtTime:function(e){return isNaN(e)?e:this.videoTimeAtTime(e)},prepareToRenderAtTime:function(e){var t=this._currentPrepID=++h;if(!this.canRender)return!1;this.prepareVideoFramesFromTime(e);for(var r,i=this._retainedFrames,n=0,a=0;r=i[a];a++)2!==r.readyState&&(r[this._framePrepIDKey]=t,r.onReadyOrFail(this._frameDidPrepare),n++);return this._preppingFrameCount=n,!n},reduceMemoryFootprint:function(){this._super(),this._clearAllRetainedFrames()},_clearAllRetainedFrames:function(){this._clearExtraRetainedFrames(),this._clearRetainedInstantaneousFrames()},_clearExtraRetainedFrames:function(){var e=this._retainedFrames;e&&(e.forEach(n),e.length=0)},_clearRetainedInstantaneousFrames:function(){this._retainedLoFrame&&this._retainedLoFrame.release(),this._retainedHiFrame&&this._retainedHiFrame.release(),this._retainedLoFrame=this._retainedHiFrame=null},_frameDidPrepare:o.a.boundFunction(function(e){e[this._framePrepIDKey]===this._currentPrepID&&(e[this._framePrepIDKey]=void 0,--this._preppingFrameCount||this.renderer.prepareToRenderAtTime(this.renderer.currentTime))}),prepareVideoFramesFromTime:function(e){this.retainFramesForTime(e)},canRenderAtTime:function(e){if("none"===this.display(e))return!0;if(!this.canRender)return!1;for(var t,r=!0,i=this.requiredFramesForTime(e),n=0;t=i[n];n++)r=r&&2===t.readyState,t.retain().release();return r},renderAtTime:function(e){if(!arguments.length)return this._super();if("none"===this.display(e))return this._clearRetainedInstantaneousFrames(),this._super(e);var t=this._videoTimeAtTime(e),r=this.requiredFramesForVideoTime(t),i=r[0]||null,n=r[1]||null;if(i&&i.retain(),n&&n.retain(),this._clearRetainedInstantaneousFrames(),this._retainedLoFrame=i,this._retainedHiFrame=n,i&&(i=i.backingFrame),n&&(n=n.backingFrame),i&&n&&i.number>n.number){var a=i;n=i,i=a}i===n&&(n=null);var o=!i||n?this.videoDecoder.fractionalIndexForTime(t):i.frameNumber,s=o-(0|o);this.renderFramePair(i,n,s),this._super(e)},renderFramePair:function(){},requiredFramesForVideoTime:function(e,t,r){void 0===t&&(t=e);var i=this.videoDecoder,n=d;if(n.length=0,t<0||e>this.videoDuration||isNaN(e)||isNaN(t))return n;var a=Math.max(0,Math.floor(i.fractionalIndexForTime(e))),o=Math.min(i.frameCount,Math.ceil(i.fractionalIndexForTime(t)));if(a===o-1){var u=i.frameTimes;u[o]-u[a]<1/30+.001&&(o=a)}for(var h=a;h<=o;h++)s.a&&0===h||n.push(i.getFrame(h,r));return n},requiredFramesForTime:function(e,t,r){return this.requiredFramesForVideoTime(this._videoTimeAtTime(e),this._videoTimeAtTime(t),r)},retainFramesForVideoTime:function(e,t,r){void 0===t&&(t=e);var a=this.requiredFramesForVideoTime(e,t,r);a.forEach(i);var o=this._retainedFrames||(this._retainedFrames=[]);o.forEach(n),o.length=0,o.push.apply(o,a)},retainFramesForTime:function(e,t,r){return this.retainFramesForVideoTime(this._videoTimeAtTime(e),this._videoTimeAtTime(t),r)},dispose:function(){this.retainFramesForVideoTime(NaN),this._super()}}),h=1,d=[];t.a=u},function(e,t,r){"use strict";function i(){u.forEach(function(e){return e()})}function n(e){u.push(e)}function a(){return window.devicePixelRatio}function o(){return Math.ceil(a())}t.a=n,t.b=o;var s=void 0,u=[];!function(){window.matchMedia&&(s=window.matchMedia("only screen and (-webkit-min-device-pixel-ratio:1.3),only screen and (-o-min-device-pixel-ratio:13/10),only screen and (min-resolution:120dpi)"),s.addListener(i))}()},function(e,t,r){"use strict";function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function n(e){var t=r.i(o.a)(e),i=h.get(t);if(i)return i;var n=e.map(function(e){if("i"===e[0]&&c(e[1]))return"I"+e.substring(1)});return e=e.concat(n.filter(function(e){return!!e})),i=new RegExp(e.join("|"),"g"),h.set(t,i),i}function a(e,t){var r=e.charCodeAt(0),i=t.charCodeAt(0),n=new Map;return function(e){var t=n.get(e);if(void 0!==t)return t;var a=e.charCodeAt(0);return t=a>=r&&a<=i,n.set(e,t),t}}var o=r(17),s=function(){function e(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,r,i){return r&&e(t.prototype,r),i&&e(t,i),t}}(),u=["iOS","iPhone","iPad","iPod","WebKit"],h=new Map,d=a("0","9"),l=a("a","z"),c=a("A","Z"),p=function(e){return l(e)||c(e)},f=function(e){return p(e)||d(e)},v=new Map,m=function(){function e(){i(this,e)}return s(e,null,[{key:"splitIntoArray",value:function(e,t,r){for(var i=e.indexOf(t),n=0,a=t.length;-1!==i;)r.push(e.substring(n,i)),n=i+a,i=e.indexOf(t,n);r.push(e.substring(n))}},{key:"hyphenate",value:function(t,i,n){if(!t)return"";i||null===i||!1===i||(i=u);var a=i||n?r.i(o.a)(i)+"#"+t+"#"+!!n:t,s=v.get(a);if(s)return s;if(Array.isArray(i)){var h=e.hyphenateCarefully(t,i,n);return v.set(a,h),h}var m=t.length,y="",g=void 0,b=void 0,_=void 0,P=void 0,k=void 0;for(g=0;g<m;g++)b=t[g-1],_=t[g],P=_.toLowerCase(),k=t[g+1],b&&f(_)&&f(b)&&(!c(b)&&c(_)||d(b)&&p(_)||k&&c(b)&&c(_)&&l(k))?y+="-"+P:y+=P;return v.set(a,y),y}},{key:"hyphenateCarefully",value:function(t,r,i){var a=n(r),o=t.match(a);if(!o||!o.length)return e.hyphenate(t,null,i);for(var s=t.split(a),u=e.hyphenate(s[0]),h=0,d=o.length;h<d;h++){var l=o[h];i||(l=l.toLowerCase());var c=s[h+1];c&&(c=e.hyphenate(c,null,i)),u+=(u&&"-")+l,c&&(u+=(p(c[0])?"-":"")+c)}return u}}]),e}();t.a=m},function(e,t,r){"use strict";function i(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function n(e,t){e||a(t)}function a(e){throw e}var o=r(2);r.d(t,"b",function(){return u}),r.d(t,"a",function(){return h});var s=function(){function e(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,r,i){return r&&e(t.prototype,r),i&&e(t,i),t}}(),u=(function(){function e(t,r){i(this,e),this.w=t,this.h=r}s(e,[{key:"toString",value:function(){return"("+this.w+", "+this.h+")"}},{key:"getHalfSize",value:function(){return new e(this.w>>>1,this.h>>>1)}},{key:"length",value:function(){return this.w*this.h}}])}(),function(){function e(t,r,n){i(this,e),this.bytes=new Uint8Array(t),this.start=r||0,this.pos=this.start,this.end=r+n||this.bytes.length}return s(e,[{key:"readU8Array",value:function(e){if(this.pos>this.end-e)return null;var t=this.bytes.subarray(this.pos,this.pos+e);return this.pos+=e,t}},{key:"readU32Array",value:function(e,t,r){if(t=t||1,this.pos>this.end-e*t*4)return null;if(1===t){for(var i=new Uint32Array(e),n=0;n<e;n++)i[n]=this.readU32();return i}for(var a=new Array(e),o=0;o<e;o++){var s=null;if(r){s={};for(var u=0;u<t;u++)s[r[u]]=this.readU32()}else{s=new Uint32Array(t);for(var h=0;h<t;h++)s[h]=this.readU32()}a[o]=s}return a}},{key:"read8",value:function(){return this.readU8()<<24>>24}},{key:"readU8",value:function(){return this.pos>=this.end?null:this.bytes[this.pos++]}},{key:"read16",value:function(){return this.readU16()<<16>>16}},{key:"readU16",value:function(){if(this.pos>=this.end-1)return null;var e=this.bytes[this.pos+0]<<8|this.bytes[this.pos+1];return this.pos+=2,e}},{key:"read24",value:function(){return this.readU24()<<8>>8}},{key:"readU24",value:function(){var e=this.pos,t=this.bytes;if(e>this.end-3)return null;var r=t[e+0]<<16|t[e+1]<<8|t[e+2];return this.pos+=3,r}},{key:"peek32",value:function(e){var t=this.pos,r=this.bytes;if(t>this.end-4)return null;var i=r[t+0]<<24|r[t+1]<<16|r[t+2]<<8|r[t+3];return e&&(this.pos+=4),i}},{key:"read32",value:function(){return this.peek32(!0)}},{key:"readU32",value:function(){return this.peek32(!0)>>>0}},{key:"read4CC",value:function(){var e=this.pos;if(e>this.end-4)return null;for(var t="",r=0;r<4;r++)t+=String.fromCharCode(this.bytes[e+r]);return this.pos+=4,t}},{key:"readFP16",value:function(){return this.read32()/65536}},{key:"readFP8",value:function(){return this.read16()/256}},{key:"readISO639",value:function(){for(var e=this.readU16(),t="",r=0;r<3;r++){var i=e>>>5*(2-r)&31;t+=String.fromCharCode(i+96)}return t}},{key:"readUTF8",value:function(e){for(var t="",r=0;r<e;r++)t+=String.fromCharCode(this.readU8());return t}},{key:"readPString",value:function(e){var t=this.readU8();n(t<=e);var r=this.readUTF8(t);return this.reserved(e-t-1,0),r}},{key:"skip",value:function(e){this.seek(this.pos+e)}},{key:"reserved",value:function(e,t){for(var r=0;r<e;r++)n(this.readU8()===t)}},{key:"seek",value:function(e){(e<0||e>this.end)&&a("Index out of bounds (bounds: [0, "+this.end+"], index: "+e+")."),this.pos=e}},{key:"subStream",value:function(t,r){return new e(this.bytes.buffer,t,r)}},{key:"length",get:function(){return this.end-this.start}},{key:"position",get:function(){return this.pos}},{key:"remaining",get:function(){return this.end-this.pos}}]),e}()),h=function(){function e(t){i(this,e),this.stream=t,this.tracks={}}return s(e,[{key:"getPath",value:function(e){for(var t=e.split("."),r=this,i=0,n=t.length;i<n;i++)r=r?r[t[i]]:void 0;return r}},{key:"readBoxes",value:function(e,t){for(;e.peek32();){var r=this.readBox(e);if(r.type in t){var i=t[r.type];Array.isArray(i)||(t[r.type]=[i]),t[r.type].push(r)}else t[r.type]=r}}},{key:"readBox",value:function(e){function t(){o.version=e.readU8(),o.flags=e.readU24()}function r(){return o.size-(e.position-o.offset)}function i(){e.skip(r())}function a(){var t=e.subStream(e.position,r());s.readBoxes(t,o),e.skip(t.length)}var o={offset:e.position},s=this;!function(){o.size=e.readU32(),o.type=e.read4CC()}();var u=void 0,h=void 0,l=void 0;switch(o.type){case"ftyp":var c=o;c.name="File Type Box",c.majorBrand=e.read4CC(),c.minorVersion=e.readU32(),c.compatibleBrands=new Array((c.size-16)/4);for(var p=0;p<c.compatibleBrands.length;p++)c.compatibleBrands[p]=e.read4CC();break;case"moov":o.name="Movie Box",a();break;case"mvhd":var f=o;f.name="Movie Header Box",t(),n(0==f.version),f.creationTime=e.readU32(),f.modificationTime=e.readU32(),f.timeScale=e.readU32(),f.duration=e.readU32(),f.rate=e.readFP16(),f.volume=e.readFP8(),e.skip(10),f.matrix=e.readU32Array(9),e.skip(24),f.nextTrackId=e.readU32();break;case"trak":var v=o;v.name="Track Box",a();var m=new d(this,v),y=v.mdia&&v.mdia.hdlr&&v.mdia.hdlr.handlerType||"unknownHandlerType",g=this.tracks;(g[y]||(g[y]=[])).push(m),g[v.tkhd.trackId]=m;break;case"tkhd":var b=o;b.name="Track Header Box",t(),n(0==b.version),b.creationTime=e.readU32(),b.modificationTime=e.readU32(),b.trackId=e.readU32(),e.skip(4),b.duration=e.readU32(),e.skip(8),b.layer=e.readU16(),b.alternateGroup=e.readU16(),b.volume=e.readFP8(),e.skip(2),b.matrix=e.readU32Array(9),b.width=e.readFP16(),b.height=e.readFP16();break;case"edts":o.name="Edit Atom",a();break;case"elst":var _=o;_.name="Edit List Atom",t(),_.editList=[],l=e.readU32();for(var P=0;P<l;P++)_.editList.push({trackDuration:e.read32(),mediaTime:e.read32(),mediaRate:e.readU32()});n(!r()),i();break;case"mdia":o.name="Media Box",a();break;case"mdhd":var k=o;k.name="Media Header Box",t(),n(0==k.version),k.creationTime=e.readU32(),k.modificationTime=e.readU32(),k.timeScale=e.readU32(),k.duration=e.readU32(),k.language=e.readISO639(),e.skip(2);break;case"hdlr":var x=o;x.name="Handler Reference Box",t(),e.skip(4),x.handlerType=e.read4CC(),e.skip(12),h=x.size-32,h>0&&(x.name=e.readUTF8(h));break;case"minf":o.name="Media Information Box",a();break;case"stbl":o.name="Sample Table Box",a();break;case"stsd":var S=o;S.name="Sample Description Box",t(),S.sd=[],e.readU32(),a();break;case"avc1":var T=o;e.reserved(6,0),T.dataReferenceIndex=e.readU16(),n(0==e.readU16()),n(0==e.readU16()),e.readU32(),e.readU32(),e.readU32(),T.width=e.readU16(),T.height=e.readU16(),T.horizontalResolution=e.readFP16(),T.verticalResolution=e.readFP16(),n(0==e.readU32()),T.frameCount=e.readU16(),T.compressorName=e.readPString(32),T.depth=e.readU16(),n(65535==e.readU16()),a();break;case"mp4a":var w=o;if(e.reserved(6,0),w.dataReferenceIndex=e.readU16(),w.version=e.readU16(),0!==w.version){i();break}e.skip(2),e.skip(4),w.channelCount=e.readU16(),w.sampleSize=e.readU16(),w.compressionId=e.readU16(),w.packetSize=e.readU16(),w.sampleRate=e.readU32()>>>16,a();break;case"esds":o.name="Elementary Stream Descriptor",t(),i();break;case"avcC":var O=o;O.name="AVC Configuration Box",O.configurationVersion=e.readU8(),O.avcProfileIndicaation=e.readU8(),O.profileCompatibility=e.readU8(),O.avcLevelIndication=e.readU8(),O.lengthSizeMinusOne=3&e.readU8(),n(3==O.lengthSizeMinusOne,"TODO"),u=31&e.readU8(),O.sps=[];for(var C=0;C<u;C++)O.sps.push(e.readU8Array(e.readU16()));u=31&e.readU8(),O.pps=[];for(var F=0;F<u;F++)O.pps.push(e.readU8Array(e.readU16()));i();break;case"btrt":var R=o;R.name="Bit Rate Box",R.bufferSizeDb=e.readU32(),R.maxBitrate=e.readU32(),R.avgBitrate=e.readU32();break;case"stts":var D=o;D.name="Decoding Time to Sample Box",t(),D.table=e.readU32Array(e.readU32(),2,["count","delta"]);break;case"stss":var A=o;A.name="Sync Sample Box",t(),A.samples=e.readU32Array(e.readU32());break;case"stsc":var L=o;L.name="Sample to Chunk Box",t(),L.table=e.readU32Array(e.readU32(),3,["firstChunk","samplesPerChunk","sampleDescriptionId"]);break;case"stsz":var I=o;I.name="Sample Size Box",t(),I.sampleSize=e.readU32(),u=e.readU32(),0==I.sampleSize&&(I.table=e.readU32Array(u));break;case"stco":var M=o;M.name="Chunk Offset Box",t(),M.table=e.readU32Array(e.readU32());break;case"smhd":var E=o;E.name="Sound Media Header Box",t(),E.balance=e.readFP8(),e.reserved(2,0);break;case"mdat":var j=o;j.name="Media Data Box",n(j.size>=8,"Cannot parse large media data yet."),j.data=e.readU8Array(r());break;default:i()}return o}},{key:"read",value:function(){var e=(new Date).getTime();this.file={},this.readBoxes(this.stream,this.file),o.a.info("Parsed stream in "+((new Date).getTime()-e)+" ms")}},{key:"traceSamples",value:function(){var e=this.tracks[1],t=this.tracks[2];o.a.info("Video Samples: "+e.getSampleCount()),o.a.info("Audio Samples: "+t.getSampleCount());for(var r=0,i=0,n=0;n<100;n++){var a=e.sampleToOffset(r),s=t.sampleToOffset(i),u=e.sampleToSize(r,1),h=t.sampleToSize(i,1);a<s?(o.a.info("V Sample "+r+" Offset : "+a+", Size : "+u),r++):(o.a.info("A Sample "+i+" Offset : "+s+", Size : "+h),i++)}}}]),e}(),d=function(){function e(t,r){i(this,e),this.file=t,this.trak=r}return s(e,[{key:"getSampleSizeTable",value:function(){return this.trak.mdia.minf.stbl.stsz.table}},{key:"getSampleCount",value:function(){return this.getSampleSizeTable().length}},{key:"sampleToSize",value:function(e,t){for(var r=this.getSampleSizeTable(),i=0,n=e;n<e+t;n++)i+=r[n];return i}},{key:"sampleToChunk",value:function(e){var t=this.trak.mdia.minf.stbl.stsc.table;if(1===t.length){var r=t[0];return n(1===r.firstChunk),{index:e/r.samplesPerChunk,offset:e%r.samplesPerChunk}}for(var i=0,a=0;a<t.length;a++){var o=t[a];if(a>0){var s=t[a-1],u=o.firstChunk-s.firstChunk,h=s.samplesPerChunk*u;if(!(e>=h))return{index:i+Math.floor(e/s.samplesPerChunk),offset:e%s.samplesPerChunk};if(e-=h,a===t.length-1)return{index:i+u+Math.floor(e/o.samplesPerChunk),offset:e%o.samplesPerChunk};i+=u}}n(!1)}},{key:"chunkToOffset",value:function(e){return this.trak.mdia.minf.stbl.stco.table[e]}},{key:"sampleToOffset",value:function(e){var t=this.sampleToChunk(e);return this.chunkToOffset(t.index)+this.sampleToSize(e-t.offset,t.offset)}},{key:"timeToSample",value:function(e){for(var t=this.trak.mdia.minf.stbl.stts.table,r=0,i=0;i<t.length;i++){var n=t[i].count*t[i].delta;if(!(e>=n))return r+Math.floor(e/t[i].delta);e-=n,r+=t[i].count}}},{key:"sampleToTime",value:function(e){for(var t=this.trak.mdia.minf.stbl.stts.table,r=0,i=0,n=0;n<t.length&&r<e;n++){var a=t[n],o=Math.min(e-r,a.count);r+=o,i+=o*a.delta}return i}},{key:"getTotalTime",value:function(){for(var e=this.trak.mdia.minf.stbl.stts.table,t=0,r=0;r<e.length;r++)t+=e[r].count*e[r].delta;return n(this.trak.mdia.mdhd.duration===t),this.trak.mdia.mdhd.duration}},{key:"getTotalTimeInSeconds",value:function(){return this.timeToSeconds(this.getTotalTime())}},{key:"getTimeScale",value:function(){return this.trak.mdia.mdhd.timeScale}},{key:"timeToSeconds",value:function(e){return e/this.getTimeScale()}},{key:"secondsToTime",value:function(e){return e*this.getTimeScale()}},{key:"secondsToSample",value:function(e){return this.timeToSample(this.secondsToTime(e))}},{key:"sampleToSeconds",value:function(e){return this.timeToSeconds(this.sampleToTime(e))}},{key:"getAllSampleTimes",value:function(){for(var e=[],t=this.getSampleCount(),r=0;r<t;r++)e.push(this.sampleToTime(r));return e}},{key:"getAllSampleSeconds",value:function(){for(var e=[],t=this.getSampleCount(),r=0;r<t;r++)e.push(this.sampleToSeconds(r));return e}},{key:"getSampleNALUnits",value:function(e){for(var t=this.file.stream.bytes,r=this.sampleToOffset(e),i=r+this.sampleToSize(e,1),n=[];i-r>0;){var a=new u(t.buffer,r).readU32();n.push(t.subarray(r+4,r+a+4)),r=r+a+4}return n}}]),e}()},function(e,t,r){"use strict";var i={staticMembers:{_pool:null,_cache:null,init:function(){this._pool=[],this._cache={},this._super()},getPoolingCacheKey:function(){throw"Must implement `getPoolingCacheKey` to use PoolCaching."},getCached:function(){var e=this.getPoolingCacheKey.apply(this,arguments),t=this._cache[e];return t||(t=this._cache[e]=this._pool.pop()||this.create(),t._poolingCacheKey=e,t.initFromPool.apply(t,arguments)),t},peekCached:function(){var e=this.getPoolingCacheKey.apply(this,arguments);return this._cache[e]||null},_disposeInstance:function(e){delete this._cache[e._poolingCacheKey],e._poolingCacheKey=void 0,e._poolingLifecycleCount=1+(0|e._poolingLifecycleCount),this._pool.push(e)}},dispose:function(){},_poolingCacheKey:null,initFromPool:function(){},_retainCount:0,retain:function(){return this._retainCount++,this},release:function(){return this._retainCount--,this._retainCount||this.dispose(),this}};t.a=i},function(e,t,r){"use strict";function i(e,t){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!t||"object"!=typeof t&&"function"!=typeof t?e:t}function n(e,t){if("function"!=typeof t&&null!==t)throw new TypeError("Super expression must either be null or a function, not "+typeof t);e.prototype=Object.create(t&&t.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),t&&(Object.setPrototypeOf?Object.setPrototypeOf(e,t):e.__proto__=t)}function a(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var o=r(16);r.d(t,"a",function(){return d}),r.d(t,"b",function(){return c}),r.d(t,"c",function(){return f}),r.d(t,"d",function(){return m});var s=function(){function e(e,t){for(var r=0;r<t.length;r++){var i=t[r];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(t,r,i){return r&&e(t.prototype,r),i&&e(t,i),t}}(),u=function(){function e(){a(this,e),this._a=[]}return s(e,[{key:"get",value:function(){return this._a.pop()||this.create()}},{key:"ret",value:function(e){this.prepare(e),this._a.push(e)}}]),e}(),h=function(e){function t(){return a(this,t),i(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return n(t,e),s(t,[{key:"create",value:function(){return[]}},{key:"prepare",value:function(e){e.length=0}}]),t}(u),d=new h,l=function(e){function t(){return a(this,t),i(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return n(t,e),s(t,[{key:"create",value:function(){return new o.a}},{key:"prepare",value:function(e){e.clear()}}]),t}(u),c=new l,p=function(e){function t(){return a(this,t),i(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return n(t,e),s(t,[{key:"create",value:function(){return Object.create(null)}},{key:"prepare",value:function(e){var t=e;for(var r in t)delete t[r]}}]),t}(u),f=new p,v=function(e){function t(){return a(this,t),i(this,(t.__proto__||Object.getPrototypeOf(t)).apply(this,arguments))}return n(t,e),s(t,[{key:"create",value:function(){return document.createElement("canvas")}},{key:"prepare",value:function(e){var t=e.parentNode;t&&t.removeChild(e),e.width=e.height=0}}]),t}(u),m=new v},function(e,t,r){"use strict";function i(e,t){return e.apply(void 0,t)}var n={_readiness:"pending",_resolutionArgs:null,_fulfillmentCallbacks:null,_rejectionCallbacks:null,onReadyOrFail:function(e,t){this._resolveIfAlreadyResolved(e,t,!1)||this._pendCallbacks(e,t)},onReadyOrFailSync:function(e,t){this._resolveIfAlreadyResolved(e,t,!0)||this._pendCallbacks(e,t)},_resolveIfAlreadyResolved:function(e,t,r){var n=this._resolutionArgs;return"success"===this._readiness&&e?(r?i(e,n):setTimeout(i,0,e,n),!0):!("failure"!==this._readiness||!t)&&(r?i(t,n):setTimeout(i,0,t,n),!0)},_pendCallbacks:function(e,t){e&&(this._fulfillmentCallbacks||(this._fulfillmentCallbacks=[])).push(e),t&&(this._rejectionCallbacks||(this._rejectionCallbacks=[])).push(t)},clearReadinessCallbacks:function(){this._fulfillmentCallbacks&&(this._fulfillmentCallbacks.length=0),this._rejectionCallbacks&&(this._rejectionCallbacks.length=0)},resetReadiness:function(){this._readiness="pending",this._resolutionArgs&&(this._resolutionArgs.length=0),this.clearReadinessCallbacks()},resolveReadiness:function(){"pending"===this._readiness&&(this._readiness="success",(this._resolutionArgs=this._resolutionArgs||[]).push.apply(this._resolutionArgs,arguments),this._invokeCallbacks(this._fulfillmentCallbacks),this.clearReadinessCallbacks())},rejectReadiness:function(){"pending"===this._readiness&&(this._readiness="failure",(this._resolutionArgs=this._resolutionArgs||[]).push.apply(this._resolutionArgs,arguments),this._invokeCallbacks(this._rejectionCallbacks),this.clearReadinessCallbacks())},_invokeCallbacks:function(e){if(e){for(var t,r=0;t=e[r];r++)t.apply(void 0,this._resolutionArgs);e.length=0}}};t.a=n},function(e,t,r){"use strict";function i(){for(var e=1;e<arguments.length;e++)this[e-1]=arguments[e];return this}function n(e){return e&&"IMG"===e.tagName&&/^data:image\/svg|\.svg\?|\.svg$/.test(e.src)}var a=document.createElement("canvas"),o=a.getContext("2d"),s=document.createElement("canvas"),u=s.getContext("2d");a.width=s.width=a.height=s.height=0;var h=!1,d=!1,l=function(e,t){for(var r=arguments.length,l=Array(r>2?r-2:0),p=2;p<r;p++)l[p-2]=arguments[p];if(n(t))return e.drawImage.apply(e,i.apply(c,arguments)),!0;var f=h,v=d;h=d=!1;var m=t instanceof HTMLImageElement?t.naturalWidth:t.width,y=t instanceof HTMLImageElement?t.naturalHeight:t.height;if(!m||!y)throw"Source image provided to drawImageSmooth was not loaded, or otherwise had no dimensions.";var g=void 0,b=void 0,_=void 0,P=void 0,k=void 0,x=void 0,S=void 0,T=void 0;switch(arguments.length-1){case 3:g=0,b=0,_=m,P=y,k=arguments[2],x=arguments[3],S=m,T=y;break;case 5:g=0,b=0,_=m,P=y,k=arguments[2],x=arguments[3],S=arguments[4],T=arguments[5];break;case 9:g=arguments[2],b=arguments[3],_=arguments[4],P=arguments[5],k=arguments[6],x=arguments[7],S=arguments[8],T=arguments[9]}var w=S/_,O=T/P;if(w&&O){var C=Math.max(w,O),F=Math.pow(2,Math.ceil(Math.log(1.1*C)/Math.log(2)));if(F>=1)return e.drawImage.apply(e,i.apply(c,arguments)),!0;var R=void 0;if(f){R="_cachedSmoothDownsample_from"+g+","+b+","+_+","+P+"@"+F+"x";var D=t[R];if(D)return e.drawImage(D,0,0,D.width,D.height,k,x,S,T),!0}if(v)return e.drawImage.apply(e,i.apply(c,arguments)),!1;var A=1,L=_,I=P,M=Math.max(Math.pow(2,Math.ceil(Math.log(L)/Math.log(2))),a.width),E=Math.max(Math.pow(2,Math.ceil(Math.log(I)/Math.log(2))),a.height);for(a.width===M&&a.height===E||(a.width=s.width=M,a.height=s.height=E),o.drawImage(t,g,b,_,P,0,0,_,P);A>F;){u.drawImage(a,0,0,L,I,0,0,L=Math.ceil(L/2),I=Math.ceil(I/2)),o.clearRect(0,0,L,I);var j=a;a=s,s=j;var U=o;o=u,u=U,A/=2}if(f){var V=document.createElement("canvas");V.width=L,V.height=I,V.getContext("2d").drawImage(a,0,0),t[R]=V}return e.drawImage(a,0,0,L,I,k,x,S,T),o.clearRect(0,0,_,P),u.clearRect(0,0,_,P),!0}};l.usingCache=function(){return h=!0,this},l.avoidingWorkIf=function(e){return d=e,this};var c=[];t.a=l},function(e,t,r){"use strict";function i(){var e="_callbacksForEventHandler"+ ++n;return function(t){var r=this[e]||(this[e]=[]);if("function"==typeof t)return r.push(t);if(r)for(var i=0,n=r.length;i<n;++i)r[i](t)}}t.a=i;var n=1},function(e,t,r){"use strict";function i(){for(var e=n()+n();e.length<16;)e+=n();return e.slice(0,16)}function n(){return Math.random().toString(16).substring(2)}t.a=i},function(e,t,r){"use strict";function i(e,t){var r=e,i=r._computedStyle;i||(i=r._computedStyle=document.defaultView.getComputedStyle(e,null));var a=i.getPropertyValue(t);return!a&&n.get(t)&&(a=n.get(t)(i)||a),a}t.a=i;var n=function(){var e=new Map;return e.set("font",function(e){for(var t="",r=0,i=a.length;r<i;r++){var n=a[r],o=e.getPropertyValue("font-"+n);if(o&&(t&&(t+=" "),t+=o,"size"===n)){var s=e.getPropertyValue("line-height");s&&(t+="/"+s)}}return t}),e}(),a=["style","variant","weight","size","family"]},function(e,t,r){"use strict";function i(e,t,r,i,n,a,o){var s=void 0;if("string"==typeof e){var u=e;"fit"===u&&(s=!1),"cover"===u&&(s=!0)}else s=!!e;var h=arguments.length;6!==h&&(o=h-1);var d=void 0,l=void 0,c=void 0,p=void 0,f=void 0;if(2===o||3===o){var v=t,m=r;l=v.height,d=v.width,p=m.height,c=m.width,f=i}else d=t,l=r,c=i,p=n,f=a;var y=d/l,g=c/p,b=s?y<g:y>g;return f=f||{},f.width=b?c:p*y,f.height=b?c/y:p,f}function n(e,t,r,n,a){return i(!1,e,t,r,n,a,arguments.length)}t.a=n},function(e,t,r){"use strict";function i(e){var t=e&&new DataView(e),r=t&&n(t)&&a(t);return r?r.orientation:NaN}function n(e){return 65496===e.getUint16(0)}function a(e){for(var t=e.byteLength,r=2,i={};r<t;){var n=e.getUint16(r);65505===n&&o(e,r+4,i),65472!==n&&65474!==n||s(e,r+5,i),r+=2+e.getUint16(r+2)}return i}function o(e,t,r){if(1165519206!==e.getUint32(t))return r;var i=t+6,n=void 0,a=e.getUint16(i);if(18761===a)n=!0;else{if(19789!==a)return r;n=!1}for(var o=i+e.getUint32(i+4,n),s=e.getUint16(o,n),u=0;u<s;u++){var h=o+12*u+2;274===e.getUint16(h,n)&&(r.orientation=e.getUint16(h+8,n))}return r}function s(e,t,r){return r.height=e.getUint16(t),r.width=e.getUint16(t+2),r}t.a=i},function(e,t,r){"use strict";t.a="1.4.9"}])});
//# sourceMappingURL=resources/livephotoskit.js.map